/*
 * Raphael 1.0 - JavaScript Vector Library
 *
 * Copyright (c) 2008 - 2009 Dmitry Baranovskiy (http://raphaeljs.com)
 * Licensed under the MIT (http://www.opensource.org/licenses/mit-license.php) license.
 */


window.Raphael=(function(){var z=/[, ]+/,H=document,o=window,s={was:"Raphael" in window,is:window.Raphael},G=function(){return L.apply(G,arguments);},C={},S={cx:0,cy:0,fill:"#fff","fill-opacity":1,font:'10px "Arial"',"font-family":'"Arial"',"font-size":"10","font-style":"normal","font-weight":400,gradient:0,height:0,href:"http://raphaeljs.com/",opacity:1,path:"M0,0",r:0,rotation:0,rx:0,ry:0,scale:"1 1",src:"",stroke:"#000","stroke-dasharray":"","stroke-linecap":"butt","stroke-linejoin":"butt","stroke-miterlimit":0,"stroke-opacity":1,"stroke-width":1,target:"_blank","text-anchor":"middle",title:"Raphael",translation:"0 0",width:0,x:0,y:0},W={cx:"number",cy:"number",fill:"colour","fill-opacity":"number","font-size":"number",height:"number",opacity:"number",path:"path",r:"number",rotation:"csv",rx:"number",ry:"number",scale:"csv",stroke:"colour","stroke-opacity":"number","stroke-width":"number",translation:"csv",width:"number",x:"number",y:"number"},X=["click","dblclick","mousedown","mousemove","mouseout","mouseover","mouseup"];G.version="1.0";G.type=(window.SVGAngle||document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1")?"SVG":"VML");G.svg=!(G.vml=G.type=="VML");G.idGenerator=0;G.fn={};G.isArray=function(R){return Object.prototype.toString.call(R)=="[object Array]";};G.setWindow=function(R){o=R;H=o.document;};G.hsb2rgb=function(AG,AE,AK){if(typeof AG=="object"&&"h" in AG&&"s" in AG&&"b" in AG){AK=AG.b;AE=AG.s;AG=AG.h;}var AB,AC,AL;if(AK==0){return{r:0,g:0,b:0,hex:"#000"};}if(AG>1||AE>1||AK>1){AG/=255;AE/=255;AK/=255;}var AD=Math.floor(AG*6),AH=(AG*6)-AD,AA=AK*(1-AE),e=AK*(1-(AE*AH)),AM=AK*(1-(AE*(1-AH)));AB=[AK,e,AA,AA,AM,AK,AK][AD];AC=[AM,AK,AK,e,AA,AA,AM][AD];AL=[AA,AA,AM,AK,AK,e,AA][AD];AB*=255;AC*=255;AL*=255;var AI={r:AB,g:AC,b:AL},R=Math.round(AB).toString(16),AF=Math.round(AC).toString(16),AJ=Math.round(AL).toString(16);if(R.length==1){R="0"+R;}if(AF.length==1){AF="0"+AF;}if(AJ.length==1){AJ="0"+AJ;}AI.hex="#"+R+AF+AJ;return AI;};G.rgb2hsb=function(R,e,AE){if(typeof R=="object"&&"r" in R&&"g" in R&&"b" in R){AE=R.b;e=R.g;R=R.r;}if(typeof R=="string"){var AG=G.getRGB(R);R=AG.r;e=AG.g;AE=AG.b;}if(R>1||e>1||AE>1){R/=255;e/=255;AE/=255;}var AD=Math.max(R,e,AE),i=Math.min(R,e,AE),AB,AA,AC=AD;if(i==AD){return{h:0,s:0,b:AD};}else{var AF=(AD-i);AA=AF/AD;if(R==AD){AB=(e-AE)/AF;}else{if(e==AD){AB=2+((AE-R)/AF);}else{AB=4+((R-e)/AF);}}AB/=6;if(AB<0){AB+=1;}if(AB>1){AB-=1;}}return{h:AB,s:AA,b:AC};};var O={},p=[];G.getRGB=function(R){if(R in O){return O[R];}var AG={aliceblue:"#f0f8ff",amethyst:"#96c",antiquewhite:"#faebd7",aqua:"#0ff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000",blanchedalmond:"#ffebcd",blue:"#00f",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#0ff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#f0f",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgreen:"#90ee90",lightgrey:"#d3d3d3",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#789",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#0f0",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#f0f",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370db",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#db7093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#f00",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#fff",whitesmoke:"#f5f5f5",yellow:"#ff0",yellowgreen:"#9acd32"},AC;if((R+"").toLowerCase() in AG){R=AG[R.toString().toLowerCase()];}if(!R){return{r:0,g:0,b:0,hex:"#000"};}if(R=="none"){return{r:-1,g:-1,b:-1,hex:"none"};}var i,AA,AF,AD=(R+"").match(/^\s*((#[a-f\d]{6})|(#[a-f\d]{3})|rgb\(\s*([\d\.]+\s*,\s*[\d\.]+\s*,\s*[\d\.]+)\s*\)|rgb\(\s*([\d\.]+%\s*,\s*[\d\.]+%\s*,\s*[\d\.]+%)\s*\)|hsb\(\s*([\d\.]+\s*,\s*[\d\.]+\s*,\s*[\d\.]+)\s*\)|hsb\(\s*([\d\.]+%\s*,\s*[\d\.]+%\s*,\s*[\d\.]+%)\s*\))\s*$/i);if(AD){if(AD[2]){AF=parseInt(AD[2].substring(5),16);AA=parseInt(AD[2].substring(3,5),16);i=parseInt(AD[2].substring(1,3),16);}if(AD[3]){AF=parseInt(AD[3].substring(3)+AD[3].substring(3),16);AA=parseInt(AD[3].substring(2,3)+AD[3].substring(2,3),16);i=parseInt(AD[3].substring(1,2)+AD[3].substring(1,2),16);}if(AD[4]){AD=AD[4].split(/\s*,\s*/);i=parseFloat(AD[0]);AA=parseFloat(AD[1]);AF=parseFloat(AD[2]);}if(AD[5]){AD=AD[5].split(/\s*,\s*/);i=parseFloat(AD[0])*2.55;AA=parseFloat(AD[1])*2.55;AF=parseFloat(AD[2])*2.55;}if(AD[6]){AD=AD[6].split(/\s*,\s*/);i=parseFloat(AD[0]);AA=parseFloat(AD[1]);AF=parseFloat(AD[2]);return G.hsb2rgb(i,AA,AF);}if(AD[7]){AD=AD[7].split(/\s*,\s*/);i=parseFloat(AD[0])*2.55;AA=parseFloat(AD[1])*2.55;AF=parseFloat(AD[2])*2.55;return G.hsb2rgb(i,AA,AF);}var AD={r:i,g:AA,b:AF},e=Math.round(i).toString(16),AB=Math.round(AA).toString(16),AE=Math.round(AF).toString(16);(e.length==1)&&(e="0"+e);(AB.length==1)&&(AB="0"+AB);(AE.length==1)&&(AE="0"+AE);AD.hex="#"+e+AB+AE;AC=AD;}else{AC={r:-1,g:-1,b:-1,hex:"none"};}if(p.length>20){delete O[p.unshift()];}p.push(R);O[R]=AC;return AC;};G.getColor=function(e){var i=this.getColor.start=this.getColor.start||{h:0,s:1,b:e||0.75},R=this.hsb2rgb(i.h,i.s,i.b);i.h+=0.075;if(i.h>1){i.h=0;i.s-=0.2;if(i.s<=0){this.getColor.start={h:0,s:1,b:i.b};}}return R.hex;};G.getColor.reset=function(){delete this.start;};var Z={"":[]},B=function(){var AA="",AD;for(var e=0,AB=this.length;e<AB;e++){for(var R=0,AC=this[e].length;R<AC;R++){AD=this[e][R];AA+=isNaN(AD)?AD:+AD.toFixed(3);R&&R!=AC-1&&(AA+=",");}e!=AB-1&&(AA+="\n");}return AA.replace(/,(?=-)/g,"");},E=[];G.parsePathString=function(R){if(R in Z){return Z[R];}var i={a:7,c:6,h:1,l:2,m:2,q:4,s:4,t:2,v:1,z:0},e=[];if(R.toString==B){e=R;}if(!e.length){(R+"").replace(/([achlmqstvz])[\s,]*((-?\d*\.?\d*(?:e[-+]?\d+)?\s*,?\s*)+)/ig,function(AB,AA,AE){var AD=[],AC=AA.toLowerCase();AE.replace(/(-?\d*\.?\d*(?:e[-+]?\d+)?)\s*,?\s*/ig,function(AG,AF){AF&&AD.push(+AF);});while(AD.length>=i[AC]){e.push([AA].concat(AD.splice(0,i[AC])));if(!i[AC]){break;}}});e.toString=B;}if(E.length>200){delete Z[E.unshift()];}E.push(R);Z[R]=e;return e;};var d=function(AH){d.cache=d.cache||{};d.count=d.count||[];if(AH in d.cache){return d.cache[AH];}AH=r(AH);var AE=0,AD=0,AA=[],e=[];for(var AB=0,AG=AH.length;AB<AG;AB++){if(AH[AB][0]=="M"){AE=AH[AB][1];AD=AH[AB][2];}else{var AC=m(AE,AD,AH[AB][1],AH[AB][2],AH[AB][3],AH[AB][4],AH[AB][5],AH[AB][6]);AA=AA.concat(AC.min.x,AC.max.x);e=e.concat(AC.min.y,AC.max.y);}}var R=Math.min.apply(0,AA),AF=Math.min.apply(0,e);if(d.count.length>100){delete d.cache[d.count.unshift()];}d.count.push(AH);return(d.cache[AH]={x:R,y:AF,width:Math.max.apply(0,AA)-R,height:Math.max.apply(0,e)-AF});},D=function(AB){if(typeof AB=="string"){AB=G.parsePathString(AB);}D.cache=D.cache||{};D.count=D.count||[];if(AB in D.cache){return V(D.cache[AB]);}var AH=[],AJ=0,AI=0,AM=0,AL=0,AA=0;if(AB[0][0]=="M"){AJ=AB[0][1];AI=AB[0][2];AM=AJ;AL=AI;AA++;AH.push(["M",AJ,AI]);}for(var AE=AA,AN=AB.length;AE<AN;AE++){var R=AH[AE]=[],AK=AB[AE];if(AK[0]!=AK[0].toLowerCase()){R[0]=AK[0].toLowerCase();switch(R[0]){case"a":R[1]=AK[1];R[2]=AK[2];R[3]=AK[3];R[4]=AK[4];R[5]=AK[5];R[6]=+(AK[6]-AJ).toFixed(3);R[7]=+(AK[7]-AI).toFixed(3);break;case"v":R[1]=+(AK[1]-AI).toFixed(3);break;case"m":AM=AK[1];AL=AK[2];default:for(var AD=1,AF=AK.length;AD<AF;AD++){R[AD]=+(AK[AD]-((AD%2)?AJ:AI)).toFixed(3);}}}else{R=AH[AE]=[];if(AK[0]=="m"){AM=AK[1]+AJ;AL=AK[2]+AI;}for(var AC=0,e=AK.length;AC<e;AC++){AH[AE][AC]=AK[AC];}}var AG=AH[AE].length;switch(AH[AE][0]){case"z":AJ=AM;AI=AL;break;case"h":AJ+=+AH[AE][AG-1];break;case"v":AI+=+AH[AE][AG-1];break;default:AJ+=+AH[AE][AG-2];AI+=+AH[AE][AG-1];}}AH.toString=B;if(D.count.length>100){delete D.cache[D.count.unshift()];}D.count.push(AB);return V(D.cache[AB]=AH);},V=function(AD){var AA=[];if(typeof AD=="string"){AD=G.parsePathString(AD);}for(var e=0,AB=AD.length;e<AB;e++){AA[e]=[];for(var R=0,AC=AD[e].length;R<AC;R++){AA[e][R]=AD[e][R];}}AA.toString=B;return AA;},Y=function(AB){if(typeof AB=="string"){AB=G.parsePathString(AB);}Y.cache=Y.cache||{};Y.count=Y.count||[];if(AB in Y.cache){return V(Y.cache[AB]);}var AG=[],AI=0,AH=0,AL=0,AK=0,AA=0;if(AB[0][0]=="M"){AI=+AB[0][1];AH=+AB[0][2];AL=AI;AK=AH;AA++;AG[0]=["M",AI,AH];}for(var AE=AA,AM=AB.length;AE<AM;AE++){var R=AG[AE]=[],AJ=AB[AE];if(AJ[0]!=(AJ[0]+"").toUpperCase()){R[0]=(AJ[0]+"").toUpperCase();switch(R[0]){case"A":R[1]=AJ[1];R[2]=AJ[2];R[3]=AJ[3];R[4]=AJ[4];R[5]=AJ[5];R[6]=+(AJ[6]+AI);R[7]=+(AJ[7]+AH);break;case"V":R[1]=+AJ[1]+AH;break;case"H":R[1]=+AJ[1]+AI;break;case"M":AL=+AJ[1]+AI;AK=+AJ[2]+AH;default:for(var AD=1,AF=AJ.length;AD<AF;AD++){R[AD]=+AJ[AD]+((AD%2)?AI:AH);}}}else{R=AG[AE]=[];for(var AC=0,e=AJ.length;AC<e;AC++){AG[AE][AC]=AJ[AC];}}switch(R[0]){case"Z":AI=AL;AH=AK;break;case"H":AI=R[1];break;case"V":AH=R[1];break;default:AI=AG[AE][AG[AE].length-2];AH=AG[AE][AG[AE].length-1];}}AG.toString=B;if(Y.count.length>100){delete Y.cache[Y.count.unshift()];}Y.count.push(AB);return V(Y.cache[AB]=AG);},F=function(e,AA,R,i){return[e,AA,R,i,R,i];},a=function(e,AA,AC,AB,R,i){return[2/3*e+1/3*AC,2/3*AA+1/3*AB,2/3*e+1/3*R,2/3*AA+1/3*i,R,i];},T=function(AI,Ai,AR,AP,AJ,AE,e,AH,Ah,AK){var AO=Math.PI*120/180,AS=[];if(!AK){var AU=(AI-AH)/2,AT=(Ai-Ah)/2,R=AR*AR,AX=AP*AP,AZ=(AE==e?-1:1)*Math.sqrt(Math.abs(R*AX-R*AT*AT-AX*AU*AU)/(R*AT*AT+AX*AU*AU)),AM=AZ*AR*AT/AP+(AI+AH)/2,AL=AZ*-AP*AU/AR+(Ai+Ah)/2,AD=Math.asin((Ai-AL)/AP),AC=Math.asin((Ah-AL)/AP);AD=AI<AM?Math.PI-AD:AD;AC=AH<AM?Math.PI-AC:AC;AD<0&&(AD=Math.PI*2+AD);AC<0&&(AC=Math.PI*2+AC);if(e&&AD>AC){AD=AD-Math.PI*2;}if(!e&&AC>AD){AC=AC-Math.PI*2;}}else{AD=AK[0];AC=AK[1];AM=AK[2];AL=AK[3];}var AG=AC-AD;if(Math.abs(AG)>AO){var AN=AC,AQ=AH,AF=Ah;AC=AD+AO*(e&&AC>AD?1:-1);AH=AM+AR*Math.cos(AC);Ah=AL+AP*Math.sin(AC);AS=arguments.callee(AH,Ah,AR,AP,AJ,0,e,AQ,AF,[AC,AN,AM,AL]);}var AB=Math.cos(AD),Ag=Math.sin(AD),AA=Math.cos(AC),Af=Math.sin(AC),AG=AC-AD,AV=Math.tan(AG/4),AY=4/3*AR*AV,AW=4/3*AP*AV,Ae=[AI,Ai],Ad=[AI+AY*Ag,Ai-AW*AB],Ac=[AH+AY*Af,Ah-AW*AA],Aa=[AH,Ah];Ad[0]=2*Ae[0]-Ad[0];Ad[1]=2*Ae[1]-Ad[1];if(AK){return[Ad,Ac,Aa].concat(AS);}else{AS=[Ad,Ac,Aa].concat(AS).join(",").split(",");for(var Ab=AS.length;Ab--;){AS[Ab]=+AS[Ab];}return AS;}},c=function(e,R,AP,AN,AC,AB,AE,AD,AJ){var AH=Math.pow(1-AJ,3)*e+Math.pow(1-AJ,2)*3*AJ*AP+(1-AJ)*3*AJ*AJ*AC+Math.pow(AJ,3)*AE,AF=Math.pow(1-AJ,3)*R+Math.pow(1-AJ,2)*3*AJ*AN+(1-AJ)*3*AJ*AJ*AB+Math.pow(AJ,3)*AD,AL=e+2*AJ*(AP-e)+AJ*AJ*(AC-2*AP+e),AK=R+2*AJ*(AN-R)+AJ*AJ*(AB-2*AN+R),AO=AP+2*AJ*(AC-AP)+AJ*AJ*(AE-2*AC+AP),AM=AN+2*AJ*(AB-AN)+AJ*AJ*(AD-2*AB+AN),AI=(1-AJ)*e+AJ*AP,AG=(1-AJ)*R+AJ*AN,AA=(1-AJ)*AC+AJ*AE,i=(1-AJ)*AB+AJ*AD;return{x:AH,y:AF,m:{x:AL,y:AK},n:{x:AO,y:AM},start:{x:AI,y:AG},end:{x:AA,y:i}};},m=function(e,R,AA,i,AN,AM,AJ,AG){var AL=(AN-2*AA+e)-(AJ-2*AN+AA),AI=2*(AA-e)-2*(AN-AA),AF=e-AA,AD=(-AI+Math.sqrt(AI*AI-4*AL*AF))/2/AL,AB=(-AI-Math.sqrt(AI*AI-4*AL*AF))/2/AL,AH=[R,AG],AK=[e,AJ],AE=c(e,R,AA,i,AN,AM,AJ,AG,AD>0&&AD<1?AD:0),AC=c(e,R,AA,i,AN,AM,AJ,AG,AB>0&&AB<1?AB:0);AK=AK.concat(AE.x,AC.x);AH=AH.concat(AE.y,AC.y);AL=(AM-2*i+R)-(AG-2*AM+i);AI=2*(i-R)-2*(AM-i);AF=R-i;AD=(-AI+Math.sqrt(AI*AI-4*AL*AF))/2/AL;AB=(-AI-Math.sqrt(AI*AI-4*AL*AF))/2/AL;AE=c(e,R,AA,i,AN,AM,AJ,AG,AD>0&&AD<1?AD:0);AC=c(e,R,AA,i,AN,AM,AJ,AG,AB>0&&AB<1?AB:0);AK=AK.concat(AE.x,AC.x);AH=AH.concat(AE.y,AC.y);return{min:{x:Math.min.apply(Math,AK),y:Math.min.apply(Math,AH)},max:{x:Math.max.apply(Math,AK),y:Math.max.apply(Math,AH)}};},r=function(AM,AH){r.cache=r.cache||{};r.count=r.count||[];if((AM+"&"+AH) in r.cache){return r.cache[AM+"&"+AH];}var AB=Y(AM),AI=AH&&Y(AH),AJ={x:0,y:0,bx:0,by:0,X:0,Y:0},R={x:0,y:0,bx:0,by:0,X:0,Y:0},AD=function(AN,AO){if(!AN){return["C",AO.x,AO.y,AO.x,AO.y,AO.x,AO.y];}switch(AN[0]){case"M":AO.X=AN[1];AO.Y=AN[2];break;case"A":AN=["C"].concat(T(AO.x,AO.y,AN[1],AN[2],AN[3],AN[4],AN[5],AN[6],AN[7]));break;case"S":var i=AO.x+(AO.x-(AO.bx||AO.x)),AP=AO.y+(AO.y-(AO.by||AO.y));AN=["C",i,AP,AN[1],AN[2],AN[3],AN[4]];break;case"T":var i=AO.x+(AO.x-(AO.bx||AO.x)),AP=AO.y+(AO.y-(AO.by||AO.y));AN=["C"].concat(a(AO.x,AO.y,i,AP,AN[1],AN[2]));break;case"Q":AN=["C"].concat(a(AO.x,AO.y,AN[1],AN[2],AN[3],AN[4]));break;case"L":AN=["C"].concat(F(AO.x,AO.y,AN[1],AN[2]));break;case"H":AN=["C"].concat(F(AO.x,AO.y,AN[1],AO.y));break;case"V":AN=["C"].concat(F(AO.x,AO.y,AO.x,AN[1]));break;case"Z":AN=["C"].concat(F(AO.x,AO.y,AO.X,AO.Y));break;}return AN;},e=function(AN,AO){if(AN[AO].length>7){AN[AO].shift();var AP=AN[AO];while(AP.length){AN.splice(AO++,0,["C"].concat(AP.splice(0,6)));}AN.splice(AO,1);AK=Math.max(AB.length,AI&&AI.length||0);}},AA=function(AR,AQ,AO,AN,AP){if(AR&&AQ&&AR[AP][0]=="M"&&AQ[AP][0]!="M"){AQ.splice(AP,0,["M",AN.x,AN.y]);AO.bx=0;AO.by=0;AO.x=AR[AP][1];AO.y=AR[AP][2];AK=Math.max(AB.length,AI&&AI.length||0);}};for(var AF=0,AK=Math.max(AB.length,AI&&AI.length||0);AF<AK;AF++){AB[AF]=AD(AB[AF],AJ);e(AB,AF);AI&&(AI[AF]=AD(AI[AF],R));AI&&e(AI,AF);AA(AB,AI,AJ,R,AF);AA(AI,AB,R,AJ,AF);var AE=AB[AF],AL=AI&&AI[AF],AC=AE.length,AG=AI&&AL.length;AJ.bx=AE[AC-4]||0;AJ.by=AE[AC-3]||0;AJ.x=AE[AC-2];AJ.y=AE[AC-1];R.bx=AI&&(AL[AG-4]||0);R.by=AI&&(AL[AG-3]||0);R.x=AI&&AL[AG-2];R.y=AI&&AL[AG-1];}if(r.count.length>100){delete r.cache[r.count.unshift()];}r.count.push(AM+"&"+AH);return(r.cache[AM+"&"+AH]=AI?[AB,AI]:AB);},N=function(AI){if(typeof AI=="string"){AI=AI.split(/\s*\-\s*/);var AA=AI.shift();if(AA.toLowerCase()=="v"){AA=90;}else{if(AA.toLowerCase()=="h"){AA=0;}else{AA=parseFloat(AA);}}AA=-AA;var AG={angle:AA,type:"linear",dots:[],vector:[0,0,Math.cos(AA*Math.PI/180).toFixed(3),Math.sin(AA*Math.PI/180).toFixed(3)]},AH=1/(Math.max(Math.abs(AG.vector[2]),Math.abs(AG.vector[3]))||1);AG.vector[2]*=AH;AG.vector[3]*=AH;if(AG.vector[2]<0){AG.vector[0]=-AG.vector[2];AG.vector[2]=0;}if(AG.vector[3]<0){AG.vector[1]=-AG.vector[3];AG.vector[3]=0;}AG.vector[0]=AG.vector[0].toFixed(3);AG.vector[1]=AG.vector[1].toFixed(3);AG.vector[2]=AG.vector[2].toFixed(3);AG.vector[3]=AG.vector[3].toFixed(3);for(var AD=0,AJ=AI.length;AD<AJ;AD++){var R={},AF=AI[AD].match(/^([^:]*):?([\d\.]*)/);R.color=G.getRGB(AF[1]).hex;AF[2]&&(R.offset=AF[2]+"%");AG.dots.push(R);}for(var AD=1,AJ=AG.dots.length-1;AD<AJ;AD++){if(!AG.dots[AD].offset){var e=parseFloat(AG.dots[AD-1].offset||0),AB=false;for(var AC=AD+1;AC<AJ;AC++){if(AG.dots[AC].offset){AB=AG.dots[AC].offset;break;}}if(!AB){AB=100;AC=AJ;}AB=parseFloat(AB);var AE=(AB-e)/(AC-AD+1);for(;AD<AC;AD++){e+=AE;AG.dots[AD].offset=e+"%";}}}return AG;}else{return AI;}},j=function(){var i,e,AB,AA,R;if(typeof arguments[0]=="string"||typeof arguments[0]=="object"){if(typeof arguments[0]=="string"){i=H.getElementById(arguments[0]);}else{i=arguments[0];}if(i.tagName){if(arguments[1]==null){return{container:i,width:i.style.pixelWidth||i.offsetWidth,height:i.style.pixelHeight||i.offsetHeight};}else{return{container:i,width:arguments[1],height:arguments[2]};}}}else{if(typeof arguments[0]=="number"&&arguments.length>3){return{container:1,x:arguments[0],y:arguments[1],width:arguments[2],height:arguments[3]};}}},A=function(R,i){var e=this;for(var AA in i){if(i.hasOwnProperty(AA)&&!(AA in R)){switch(typeof i[AA]){case"function":(function(AB){R[AA]=R===e?AB:function(){return AB.apply(e,arguments);};})(i[AA]);break;case"object":R[AA]=R[AA]||{};A.call(this,R[AA],i[AA]);break;default:R[AA]=i[AA];break;}}}};if(G.svg){G.toString=function(){return"Your browser supports SVG.\nYou are running Rapha\u00ebl "+this.version;};var y=function(R,AA){var e=H.createElementNS(AA.svgns,"path");if(AA.canvas){AA.canvas.appendChild(e);}var i=new M(e,AA);i.type="path";i.attrs.path=G.parsePathString(R);R&&i.node.setAttribute("d",i.attrs.path);h(i,{fill:"none",stroke:"#000"});return i;};var q=function(AE,AC,AF){AC=N(AC);var AB=H.createElementNS(AF.svgns,(AC.type||"linear")+"Gradient");AB.id="raphael-gradient-"+G.idGenerator++;if(AC.vector&&AC.vector.length){AB.setAttribute("x1",AC.vector[0]);AB.setAttribute("y1",AC.vector[1]);AB.setAttribute("x2",AC.vector[2]);AB.setAttribute("y2",AC.vector[3]);}AF.defs.appendChild(AB);var AD=true;for(var e=0,AA=AC.dots.length;e<AA;e++){var R=H.createElementNS(AF.svgns,"stop");if(AC.dots[e].offset){AD=false;}R.setAttribute("offset",AC.dots[e].offset?AC.dots[e].offset:(e==0)?"0%":"100%");R.setAttribute("stop-color",G.getRGB(AC.dots[e].color).hex||"#fff");AB.appendChild(R);}if(AD&&typeof AC.dots[AA-1].opacity!="undefined"){R.setAttribute("stop-opacity",AC.dots[AA-1].opacity);}AE.setAttribute("fill","url(#"+AB.id+")");AE.style.fill="";AE.style.opacity=1;AE.style.fillOpacity=1;AE.setAttribute("opacity",1);AE.setAttribute("fill-opacity",1);};var U=function(e){if(e.pattern){var R=e.getBBox();e.pattern.setAttribute("patternTransform","translate(".concat(R.x,",",R.y,")"));}};var h=function(AH,AO){var AK={"":[0],none:[0],"-":[3,1],".":[1,1],"-.":[3,1,1,1],"-..":[3,1,1,1,1,1],". ":[1,3],"- ":[4,3],"--":[8,3],"- .":[4,3,1,3],"--.":[8,3,1,3],"--..":[8,3,1,3,1,3]},AM=AH.node,AI=AH.attrs,AE=AH.attr("rotation"),AB=function(AW,AV){AV=AK[(AV+"").toLowerCase()];if(AV){var AT=AW.attrs["stroke-width"]||"1",AQ={round:AT,square:AT,butt:0}[AW.attrs["stroke-linecap"]||AO["stroke-linecap"]]||0,AU=[];for(var AR=0,AS=AV.length;AR<AS;AR++){AU.push(AV[AR]*AT+((AR%2)?1:-1)*AQ);}AV=AU.join(",");AM.setAttribute("stroke-dasharray",AV);}};AH.rotate(0,true);for(var AL in AO){if(!(AL in S)){continue;}var AJ=AO[AL];AI[AL]=AJ;switch(AL){case"href":case"title":case"target":var AN=AM.parentNode;if(AN.tagName.toLowerCase()!="a"){var i=H.createElementNS(AH.paper.svgns,"a");AN.insertBefore(i,AM);i.appendChild(AM);AN=i;}AN.setAttributeNS(AH.paper.xlink,AL,AJ);break;case"path":if(AH.type=="path"){AI.path=G.parsePathString(AJ);AM.setAttribute("d",AI.path);}case"width":AM.setAttribute(AL,AJ);if(AI.fx){AL="x";AJ=AI.x;}else{break;}case"x":if(AI.fx){AJ=-AI.x-(AI.width||0);}case"rx":case"cx":AM.setAttribute(AL,AJ);U(AH);break;case"height":AM.setAttribute(AL,AJ);if(AI.fy){AL="y";AJ=AI.y;}else{break;}case"y":if(AI.fy){AJ=-AI.y-(AI.height||0);}case"ry":case"cy":AM.setAttribute(AL,AJ);U(AH);break;case"r":if(AH.type=="rect"){AM.setAttribute("rx",AJ);AM.setAttribute("ry",AJ);}else{AM.setAttribute(AL,AJ);}break;case"src":if(AH.type=="image"){AM.setAttributeNS(AH.paper.xlink,"href",AJ);}break;case"stroke-width":AM.style.strokeWidth=AJ;AM.setAttribute(AL,AJ);if(AI["stroke-dasharray"]){AB(AH,AI["stroke-dasharray"]);}break;case"stroke-dasharray":AB(AH,AJ);break;case"rotation":AE=AJ;AH.rotate(AJ,true);break;case"translation":var AC=(AJ+"").split(z);AH.translate((+AC[0]+1||2)-1,(+AC[1]+1||2)-1);break;case"scale":var AC=(AJ+"").split(z);AH.scale(+AC[0]||1,+AC[1]||+AC[0]||1,+AC[2]||null,+AC[3]||null);break;case"fill":var AA=(AJ+"").match(/^url\(([^\)]+)\)$/i);if(AA){var e=H.createElementNS(AH.paper.svgns,"pattern"),AG=H.createElementNS(AH.paper.svgns,"image");e.id="raphael-pattern-"+G.idGenerator++;e.setAttribute("x",0);e.setAttribute("y",0);e.setAttribute("patternUnits","userSpaceOnUse");AG.setAttribute("x",0);AG.setAttribute("y",0);AG.setAttributeNS(AH.paper.xlink,"href",AA[1]);e.appendChild(AG);var AP=H.createElement("img");AP.style.position="absolute";AP.style.top="-9999em";AP.style.left="-9999em";AP.onload=function(){e.setAttribute("width",this.offsetWidth);e.setAttribute("height",this.offsetHeight);AG.setAttribute("width",this.offsetWidth);AG.setAttribute("height",this.offsetHeight);H.body.removeChild(this);C.safari();};H.body.appendChild(AP);AP.src=AA[1];AH.paper.defs.appendChild(e);AM.style.fill="url(#"+e.id+")";AM.setAttribute("fill","url(#"+e.id+")");AH.pattern=e;U(AH);break;}delete AO.gradient;delete AI.gradient;if(typeof AI.opacity!="undefined"&&typeof AO.opacity=="undefined"){AM.style.opacity=AI.opacity;AM.setAttribute("opacity",AI.opacity);}if(typeof AI["fill-opacity"]!="undefined"&&typeof AO["fill-opacity"]=="undefined"){AM.style.fillOpacity=AH.attrs["fill-opacity"];AM.setAttribute("fill-opacity",AI["fill-opacity"]);}case"stroke":AM.style[AL]=G.getRGB(AJ).hex;AM.setAttribute(AL,G.getRGB(AJ).hex);break;case"gradient":q(AM,AJ,AH.paper);break;case"opacity":case"fill-opacity":if(AI.gradient){var R=H.getElementById(AM.getAttribute("fill").replace(/^url\(#|\)$/g,""));if(R){var AD=R.getElementsByTagName("stop");AD[AD.length-1].setAttribute("stop-opacity",AJ);}break;}default:var AF=AL.replace(/(\-.)/g,function(AQ){return AQ.substring(1).toUpperCase();});AM.style[AF]=AJ;AM.setAttribute(AL,AJ);break;}}v(AH,AO);AH.rotate(AE,true);};var n=1.2;var v=function(R,AB){if(R.type!="text"||!("text" in AB||"font" in AB||"font-size" in AB||"x" in AB||"y" in AB)){return ;}var AG=R.attrs,e=R.node,AI=e.firstChild?parseInt(H.defaultView.getComputedStyle(e.firstChild,"").getPropertyValue("font-size"),10):10;if("text" in AB){while(e.firstChild){e.removeChild(e.firstChild);}var AA=(AB.text+"").split("\n");for(var AC=0,AH=AA.length;AC<AH;AC++){var AE=H.createElementNS(R.paper.svgns,"tspan");AC&&AE.setAttribute("dy",AI*n);AC&&AE.setAttribute("x",AG.x);AE.appendChild(H.createTextNode(AA[AC]));e.appendChild(AE);}}else{var AA=e.getElementsByTagName("tspan");for(var AC=0,AH=AA.length;AC<AH;AC++){AC&&AA[AC].setAttribute("dy",AI*n);AC&&AA[AC].setAttribute("x",AG.x);}}e.setAttribute("y",AG.y);var AD=R.getBBox(),AF=AG.y-(AD.y+AD.height/2);AF&&e.setAttribute("y",AG.y+AF);};var M=function(e,R){var AA=0,i=0;this[0]=e;this.node=e;this.paper=R;this.attrs=this.attrs||{};this.transformations=[];this._={tx:0,ty:0,rt:{deg:0,cx:0,cy:0},sx:1,sy:1};};M.prototype.rotate=function(e,R,AA){if(e==null){if(this._.rt.cx){return[this._.rt.deg,this._.rt.cx,this._.rt.cy].join(" ");}return this._.rt.deg;}var i=this.getBBox();e=(e+"").split(z);if(e.length-1){R=parseFloat(e[1]);AA=parseFloat(e[2]);}e=parseFloat(e[0]);if(R!=null){this._.rt.deg=e;}else{this._.rt.deg+=e;}(AA==null)&&(R=null);this._.rt.cx=R;this._.rt.cy=AA;R=R==null?i.x+i.width/2:R;AA=AA==null?i.y+i.height/2:AA;if(this._.rt.deg){this.transformations[0]="rotate(".concat(this._.rt.deg," ",R," ",AA,")");}else{this.transformations[0]="";}this.node.setAttribute("transform",this.transformations.join(" "));return this;};M.prototype.hide=function(){this.node.style.display="none";return this;};M.prototype.show=function(){this.node.style.display="block";return this;};M.prototype.remove=function(){this.node.parentNode.removeChild(this.node);};M.prototype.getBBox=function(){if(this.node.style.display=="none"){this.show();var AA=true;}var AE={};try{AE=this.node.getBBox();}catch(AC){}finally{AE=AE||{};}if(this.type=="text"){AE={x:AE.x,y:Infinity,width:AE.width,height:0};for(var R=0,AB=this.node.getNumberOfChars();R<AB;R++){var AD=this.node.getExtentOfChar(R);(AD.y<AE.y)&&(AE.y=AD.y);(AD.y+AD.height-AE.y>AE.height)&&(AE.height=AD.y+AD.height-AE.y);}}AA&&this.hide();return AE;};M.prototype.attr=function(){if(arguments.length==1&&typeof arguments[0]=="string"){if(arguments[0]=="translation"){return this.translate();}if(arguments[0]=="rotation"){return this.rotate();}if(arguments[0]=="scale"){return this.scale();}return this.attrs[arguments[0]];}if(arguments.length==1&&G.isArray(arguments[0])){var R={};for(var e in arguments[0]){R[arguments[0][e]]=this.attrs[arguments[0][e]];}return R;}if(arguments.length==2){var i={};i[arguments[0]]=arguments[1];h(this,i);}else{if(arguments.length==1&&typeof arguments[0]=="object"){h(this,arguments[0]);}}return this;};M.prototype.toFront=function(){this.node.parentNode.appendChild(this.node);return this;};M.prototype.toBack=function(){if(this.node.parentNode.firstChild!=this.node){this.node.parentNode.insertBefore(this.node,this.node.parentNode.firstChild);}return this;};M.prototype.insertAfter=function(R){if(R.node.nextSibling){R.node.parentNode.insertBefore(this.node,R.node.nextSibling);}else{R.node.parentNode.appendChild(this.node);}return this;};M.prototype.insertBefore=function(R){var e=R.node;e.parentNode.insertBefore(this.node,e);return this;};var f=function(e,R,AC,AB){var AA=H.createElementNS(e.svgns,"circle");AA.setAttribute("cx",R);AA.setAttribute("cy",AC);AA.setAttribute("r",AB);AA.setAttribute("fill","none");AA.setAttribute("stroke","#000");if(e.canvas){e.canvas.appendChild(AA);}var i=new M(AA,e);i.attrs=i.attrs||{};i.attrs.cx=R;i.attrs.cy=AC;i.attrs.r=AB;i.attrs.stroke="#000";i.type="circle";return i;};var l=function(i,R,AE,e,AC,AD){var AB=H.createElementNS(i.svgns,"rect");AB.setAttribute("x",R);AB.setAttribute("y",AE);AB.setAttribute("width",e);AB.setAttribute("height",AC);if(AD){AB.setAttribute("rx",AD);AB.setAttribute("ry",AD);}AB.setAttribute("fill","none");AB.setAttribute("stroke","#000");if(i.canvas){i.canvas.appendChild(AB);}var AA=new M(AB,i);AA.attrs=AA.attrs||{};AA.attrs.x=R;AA.attrs.y=AE;AA.attrs.width=e;AA.attrs.height=AC;AA.attrs.stroke="#000";if(AD){AA.attrs.rx=AA.attrs.ry=AD;}AA.type="rect";return AA;};var I=function(e,R,AD,AC,AB){var AA=H.createElementNS(e.svgns,"ellipse");AA.setAttribute("cx",R);AA.setAttribute("cy",AD);AA.setAttribute("rx",AC);AA.setAttribute("ry",AB);AA.setAttribute("fill","none");AA.setAttribute("stroke","#000");if(e.canvas){e.canvas.appendChild(AA);}var i=new M(AA,e);i.attrs=i.attrs||{};i.attrs.cx=R;i.attrs.cy=AD;i.attrs.rx=AC;i.attrs.ry=AB;i.attrs.stroke="#000";i.type="ellipse";return i;};var Q=function(i,AD,R,AE,e,AC){var AB=H.createElementNS(i.svgns,"image");AB.setAttribute("x",R);AB.setAttribute("y",AE);AB.setAttribute("width",e);AB.setAttribute("height",AC);AB.setAttribute("preserveAspectRatio","none");AB.setAttributeNS(i.xlink,"href",AD);if(i.canvas){i.canvas.appendChild(AB);}var AA=new M(AB,i);AA.attrs=AA.attrs||{};AA.attrs.src=AD;AA.attrs.x=R;AA.attrs.y=AE;AA.attrs.width=e;AA.attrs.height=AC;AA.type="image";return AA;};var k=function(e,R,AC,AB){var AA=H.createElementNS(e.svgns,"text");AA.setAttribute("x",R);AA.setAttribute("y",AC);AA.setAttribute("text-anchor","middle");if(e.canvas){e.canvas.appendChild(AA);}var i=new M(AA,e);i.attrs=i.attrs||{};i.attrs.text=AB;i.attrs.x=R;i.attrs.y=AC;i.type="text";h(i,{font:S.font,stroke:"none",fill:"#000",text:AB});return i;};var g=function(e,R){this.width=e||this.width;this.height=R||this.height;this.canvas.setAttribute("width",this.width);this.canvas.setAttribute("height",this.height);return this;};var L=function(){var AA=j.apply(null,arguments),i=AA.container,e=AA.x,AD=AA.y,AB=AA.width,R=AA.height;if(!i){throw new Error("SVG container not found.");}C.canvas=H.createElementNS(C.svgns,"svg");C.canvas.setAttribute("width",AB||512);C.width=AB||512;C.canvas.setAttribute("height",R||342);C.height=R||342;if(i==1){H.body.appendChild(C.canvas);C.canvas.style.position="absolute";C.canvas.style.left=e+"px";C.canvas.style.top=AD+"px";}else{if(i.firstChild){i.insertBefore(C.canvas,i.firstChild);}else{i.appendChild(C.canvas);}}i={canvas:C.canvas,clear:function(){while(this.canvas.firstChild){this.canvas.removeChild(this.canvas.firstChild);}this.defs=H.createElementNS(C.svgns,"defs");this.canvas.appendChild(this.defs);}};for(var AC in C){if(AC!="create"){i[AC]=C[AC];}}A.call(i,i,G.fn);i.clear();i.raphael=G;return i;};C.remove=function(){this.canvas.parentNode&&this.canvas.parentNode.removeChild(this.canvas);};C.svgns="http://www.w3.org/2000/svg";C.xlink="http://www.w3.org/1999/xlink";C.safari=function(){if({"Apple Computer, Inc.":1,"Google Inc.":1}[navigator.vendor]){var R=this.rect(-this.width,-this.height,this.width*3,this.height*3).attr({stroke:"none"});setTimeout(function(){R.remove();});}};}if(G.vml){var b=function(AD){var AB=r(AD);for(var e=0,AA=AB.length;e<AA;e++){for(var R=0,AC=AB[e].length;R<AC;R++){AB[e][R]=isNaN(AB[e][R])?AB[e][R]:Math.round(AB[e][R]);}}return(AB+"").toLowerCase().replace(/z/g,"x");};G.toString=function(){return"Your browser doesn\u2019t support SVG. Assuming it is Internet Explorer and falling down to VML.\nYou are running Rapha\u00ebl "+this.version;};var y=function(R,AC){var AA=x("group"),AD=AA.style;AD.position="absolute";AD.left=0;AD.top=0;AD.width=AC.width+"px";AD.height=AC.height+"px";AA.coordsize=AC.coordsize;AA.coordorigin=AC.coordorigin;var i=x("shape"),e=i.style;e.width=AC.width+"px";e.height=AC.height+"px";i.path="";i.coordsize=this.coordsize;i.coordorigin=this.coordorigin;AA.appendChild(i);var AB=new M(i,AA,AC);AB.isAbsolute=true;AB.type="path";AB.path=[];AB.Path="";if(R){AB.attrs.path=G.parsePathString(R);AB.node.path=b(AB.attrs.path);}h(AB,{fill:"none",stroke:"#000"});AB.setBox();AC.canvas.appendChild(AA);return AB;};var h=function(R,i){var e=R.node,AJ=e.style,AI,AD=R;R.attrs=R.attrs||{};for(var AC in i){R.attrs[AC]=i[AC];}i.href&&(e.href=i.href);i.title&&(e.title=i.title);i.target&&(e.target=i.target);if(i.path&&R.type=="path"){R.node.path=b(i.path);}if(i.rotation!=null){R.rotate(i.rotation,true);}if(i.translation){AI=(i.translation+"").split(z);R.translate(AI[0],AI[1]);}if(i.scale){AI=(i.scale+"").split(z);R.scale(+AI[0]||1,+AI[1]||+AI[0]||1,+AI[2]||null,+AI[3]||null);}if(R.type=="image"&&i.src){e.src=i.src;}if(R.type=="image"&&i.opacity){e.filterOpacity=" progid:DXImageTransform.Microsoft.Alpha(opacity="+(i.opacity*100)+")";e.style.filter=(e.filterMatrix||"")+(e.filterOpacity||"");}i.font&&(AJ.font=i.font);i["font-family"]&&(AJ.fontFamily='"'+i["font-family"].split(",")[0].replace(/^['"]+|['"]+$/g,"")+'"');i["font-size"]&&(AJ.fontSize=i["font-size"]);i["font-weight"]&&(AJ.fontWeight=i["font-weight"]);i["font-style"]&&(AJ.fontStyle=i["font-style"]);if(typeof i.opacity!="undefined"||typeof i["stroke-width"]!="undefined"||typeof i.fill!="undefined"||typeof i.stroke!="undefined"||i["stroke-width"]||i["stroke-opacity"]||i["fill-opacity"]||i["stroke-dasharray"]||i["stroke-miterlimit"]||i["stroke-linejoin"]||i["stroke-linecap"]){R=R.shape||e;var AH=(R.getElementsByTagName("fill")&&R.getElementsByTagName("fill")[0])||x("fill");if("fill-opacity" in i||"opacity" in i){var AB=((+i["fill-opacity"]+1||2)-1)*((+i.opacity+1||2)-1);AB<0&&(AB=0);AB>1&&(AB=1);AH.opacity=AB;}i.fill&&(AH.on=true);if(typeof AH.on=="undefined"||i.fill=="none"){AH.on=false;}if(AH.on&&i.fill){var AA=i.fill.match(/^url\(([^\)]+)\)$/i);if(AA){AH.src=AA[1];AH.type="tile";}else{AH.color=G.getRGB(i.fill).hex;AH.src="";AH.type="solid";}}R.appendChild(AH);var AG=(R.getElementsByTagName("stroke")&&R.getElementsByTagName("stroke")[0])||x("stroke");if((i.stroke&&i.stroke!="none")||i["stroke-width"]||typeof i["stroke-opacity"]!="undefined"||i["stroke-dasharray"]||i["stroke-miterlimit"]||i["stroke-linejoin"]||i["stroke-linecap"]){AG.on=true;}if(i.stroke=="none"||typeof AG.on=="undefined"||i.stroke==0){AG.on=false;}if(AG.on&&i.stroke){AG.color=G.getRGB(i.stroke).hex;}var AB=((+i["stroke-opacity"]+1||2)-1)*((+i.opacity+1||2)-1);AB<0&&(AB=0);AB>1&&(AB=1);AG.opacity=AB;i["stroke-linejoin"]&&(AG.joinstyle=i["stroke-linejoin"]||"miter");AG.miterlimit=i["stroke-miterlimit"]||8;i["stroke-linecap"]&&(AG.endcap={butt:"flat",square:"square",round:"round"}[i["stroke-linecap"]]||"miter");i["stroke-width"]&&(AG.weight=(parseFloat(i["stroke-width"])||1)*12/16);if(i["stroke-dasharray"]){var AE={"-":"shortdash",".":"shortdot","-.":"shortdashdot","-..":"shortdashdotdot",". ":"dot","- ":"dash","--":"longdash","- .":"dashdot","--.":"longdashdot","--..":"longdashdotdot"};AG.dashstyle=AE[i["stroke-dasharray"]]||"";}R.appendChild(AG);}if(AD.type=="text"){var AJ=C.span.style,AF=AD.attrs;AF.font&&(AJ.font=AF.font);AF["font-family"]&&(AJ.fontFamily=AF["font-family"]);AF["font-size"]&&(AJ.fontSize=AF["font-size"]);AF["font-weight"]&&(AJ.fontWeight=AF["font-weight"]);AF["font-style"]&&(AJ.fontStyle=AF["font-style"]);C.span.innerHTML="";C.span.appendChild(H.createTextNode(AD.node.string));AD.W=AF.w=C.span.offsetWidth;AD.H=AF.h=C.span.offsetHeight;AD.X=AF.x;AD.Y=AF.y+Math.round(AD.H/2);switch(AF["text-anchor"]){case"start":AD.node.style["v-text-align"]="left";AD.bbx=Math.round(AD.W/2);break;case"end":AD.node.style["v-text-align"]="right";AD.bbx=-Math.round(AD.W/2);break;default:AD.node.style["v-text-align"]="center";break;}}};var P=function(e,R,AB,AA){var i=Math.round(Math.atan((parseFloat(AB)-parseFloat(e))/(parseFloat(AA)-parseFloat(R)))*57.29)||0;if(!i&&parseFloat(e)<parseFloat(R)){i=180;}i-=180;if(i<0){i+=360;}return i;};var q=function(AE,AD){AD=N(AD);AE.attrs=AE.attrs||{};var e=AE.attrs,AC=AE.node.getElementsByTagName("fill");AE.attrs.gradient=AD;AE=AE.shape||AE.node;if(AC.length){AC=AC[0];}else{AC=x("fill");}if(AD.dots.length){AC.on=true;AC.method="none";AC.type=((AD.type+"").toLowerCase()=="radial")?"gradientTitle":"gradient";if(typeof AD.dots[0].color!="undefined"){AC.color=G.getRGB(AD.dots[0].color).hex;}if(typeof AD.dots[AD.dots.length-1].color!="undefined"){AC.color2=G.getRGB(AD.dots[AD.dots.length-1].color).hex;}var AF=[];for(var AA=0,AB=AD.dots.length;AA<AB;AA++){if(AD.dots[AA].offset){AF.push(AD.dots[AA].offset+" "+G.getRGB(AD.dots[AA].color).hex);}}var R=typeof AD.dots[AD.dots.length-1].opacity=="undefined"?(typeof e.opacity=="undefined"?1:e.opacity):AD.dots[AD.dots.length-1].opacity;if(AF.length){AC.colors.value=AF.join(",");R=typeof e.opacity=="undefined"?1:e.opacity;}else{AC.colors&&(AC.colors.value="0% "+AC.color);}AC.opacity=R;if(typeof AD.angle!="undefined"){AC.angle=(-AD.angle+270)%360;}else{if(AD.vector){AC.angle=P.apply(null,AD.vector);}}if((AD.type+"").toLowerCase()=="radial"){AC.focus="100%";AC.focusposition="0.5 0.5";}}};var M=function(AB,AD,R){var AC=0,i=0,e=0,AA=1;this[0]=AB;this.node=AB;this.X=0;this.Y=0;this.attrs={};this.Group=AD;this.paper=R;this._={tx:0,ty:0,rt:{deg:0},sx:1,sy:1};};M.prototype.rotate=function(e,R,i){if(e==null){if(this._.rt.cx){return[this._.rt.deg,this._.rt.cx,this._.rt.cy].join(" ");}return this._.rt.deg;}e=(e+"").split(z);if(e.length-1){R=parseFloat(e[1]);i=parseFloat(e[2]);}e=parseFloat(e[0]);if(R!=null){this._.rt.deg=e;}else{this._.rt.deg+=e;}(i==null)&&(R=null);this._.rt.cx=R;this._.rt.cy=i;this.setBox(this.attrs,R,i);this.Group.style.rotation=this._.rt.deg;return this;};M.prototype.setBox=function(AC,AD,AB){var e=this.Group.style,AE=(this.shape&&this.shape.style)||this.node.style;AC=AC||{};for(var AF in AC){this.attrs[AF]=AC[AF];}AD=AD||this._.rt.cx;AB=AB||this._.rt.cy;var AI=this.attrs,AL,AK,AM,AH;switch(this.type){case"circle":AL=AI.cx-AI.r;AK=AI.cy-AI.r;AM=AH=AI.r*2;break;case"ellipse":AL=AI.cx-AI.rx;AK=AI.cy-AI.ry;AM=AI.rx*2;AH=AI.ry*2;break;case"rect":case"image":AL=AI.x;AK=AI.y;AM=AI.width||0;AH=AI.height||0;break;case"text":this.textpath.v=["m",Math.round(AI.x),", ",Math.round(AI.y-2),"l",Math.round(AI.x)+1,", ",Math.round(AI.y-2)].join("");AL=AI.x-Math.round(this.W/2);AK=AI.y-this.H/2;AM=this.W;AH=this.H;break;case"path":if(!this.attrs.path){AL=0;AK=0;AM=this.paper.width;AH=this.paper.height;}else{var AG=d(this.attrs.path),AL=AG.x;AK=AG.y;AM=AG.width;AH=AG.height;}break;default:AL=0;AK=0;AM=this.paper.width;AH=this.paper.height;break;}AD=(AD==null)?AL+AM/2:AD;AB=(AB==null)?AK+AH/2:AB;var AA=AD-this.paper.width/2,AJ=AB-this.paper.height/2;if(this.type=="path"||this.type=="text"){(e.left!=AA+"px")&&(e.left=AA+"px");(e.top!=AJ+"px")&&(e.top=AJ+"px");this.X=this.type=="text"?AL:-AA;this.Y=this.type=="text"?AK:-AJ;this.W=AM;this.H=AH;(AE.left!=-AA+"px")&&(AE.left=-AA+"px");(AE.top!=-AJ+"px")&&(AE.top=-AJ+"px");}else{(e.left!=AA+"px")&&(e.left=AA+"px");(e.top!=AJ+"px")&&(e.top=AJ+"px");this.X=AL;this.Y=AK;this.W=AM;this.H=AH;(e.width!=this.paper.width+"px")&&(e.width=this.paper.width+"px");(e.height!=this.paper.height+"px")&&(e.height=this.paper.height+"px");(AE.left!=AL-AA+"px")&&(AE.left=AL-AA+"px");(AE.top!=AK-AJ+"px")&&(AE.top=AK-AJ+"px");(AE.width!=AM+"px")&&(AE.width=AM+"px");(AE.height!=AH+"px")&&(AE.height=AH+"px");var AN=(+AC.r||0)/(Math.min(AM,AH));if(this.type=="rect"&&this.arcsize!=AN&&(AN||this.arcsize)){var R=x(AN?"roundrect":"rect");R.arcsize=AN;this.Group.appendChild(R);this.node.parentNode.removeChild(this.node);this.node=R;this.arcsize=AN;h(this,this.attrs);this.setBox(this.attrs);}}};M.prototype.hide=function(){this.Group.style.display="none";return this;};M.prototype.show=function(){this.Group.style.display="block";return this;};M.prototype.getBBox=function(){if(this.type=="path"){return d(this.attrs.path);}return{x:this.X+(this.bbx||0),y:this.Y,width:this.W,height:this.H};};M.prototype.remove=function(){this[0].parentNode.removeChild(this[0]);this.Group.parentNode.removeChild(this.Group);this.shape&&this.shape.parentNode.removeChild(this.shape);};M.prototype.attr=function(){if(arguments.length==1&&typeof arguments[0]=="string"){if(arguments[0]=="translation"){return this.translate();}if(arguments[0]=="rotation"){return this.rotate();}if(arguments[0]=="scale"){return this.scale();}return this.attrs[arguments[0]];}if(this.attrs&&arguments.length==1&&G.isArray(arguments[0])){var R={};for(var e=0,AA=arguments[0].length;e<AA;e++){R[arguments[0][e]]=this.attrs[arguments[0][e]];}return R;}var AB;if(arguments.length==2){AB={};AB[arguments[0]]=arguments[1];}if(arguments.length==1&&typeof arguments[0]=="object"){AB=arguments[0];}if(AB){if(AB.gradient){q(this,AB.gradient);}if(AB.text&&this.type=="text"){this.node.string=AB.text;}h(this,AB);this.setBox(this.attrs);}return this;};M.prototype.toFront=function(){this.Group.parentNode.appendChild(this.Group);return this;};M.prototype.toBack=function(){if(this.Group.parentNode.firstChild!=this.Group){this.Group.parentNode.insertBefore(this.Group,this.Group.parentNode.firstChild);}return this;};M.prototype.insertAfter=function(R){if(R.Group.nextSibling){R.Group.parentNode.insertBefore(this.Group,R.Group.nextSibling);}else{R.Group.parentNode.appendChild(this.Group);}return this;};M.prototype.insertBefore=function(R){R.Group.parentNode.insertBefore(this.Group,R.Group);return this;};var f=function(e,AF,AE,R){var AB=x("group"),AA=AB.style,i=x("oval"),AD=i.style;AA.position="absolute";AA.left=0;AA.top=0;AA.width=e.width+"px";AA.height=e.height+"px";AB.coordsize=e.coordsize;AB.coordorigin=e.coordorigin;AB.appendChild(i);var AC=new M(i,AB,e);AC.type="circle";h(AC,{stroke:"#000",fill:"none"});AC.attrs.cx=AF;AC.attrs.cy=AE;AC.attrs.r=R;AC.setBox({x:AF-R,y:AE-R,width:R*2,height:R*2});e.canvas.appendChild(AB);return AC;};var l=function(e,AF,AE,AG,AB,R){var AC=x("group"),AA=AC.style,i=x(R?"roundrect":"rect"),AH=(+R||0)/(Math.min(AG,AB));i.arcsize=AH;AA.position="absolute";AA.left=0;AA.top=0;AA.width=e.width+"px";AA.height=e.height+"px";AC.coordsize=e.coordsize;AC.coordorigin=e.coordorigin;AC.appendChild(i);var AD=new M(i,AC,e);AD.type="rect";h(AD,{stroke:"#000"});AD.arcsize=AH;AD.setBox({x:AF,y:AE,width:AG,height:AB,r:+R});e.canvas.appendChild(AC);return AD;};var I=function(R,AG,AF,i,e){var AC=x("group"),AB=AC.style,AA=x("oval"),AE=AA.style;AB.position="absolute";AB.left=0;AB.top=0;AB.width=R.width+"px";AB.height=R.height+"px";AC.coordsize=R.coordsize;AC.coordorigin=R.coordorigin;AC.appendChild(AA);var AD=new M(AA,AC,R);AD.type="ellipse";h(AD,{stroke:"#000"});AD.attrs.cx=AG;AD.attrs.cy=AF;AD.attrs.rx=i;AD.attrs.ry=e;AD.setBox({x:AG-i,y:AF-e,width:i*2,height:e*2});R.canvas.appendChild(AC);return AD;};var Q=function(e,R,AG,AF,AH,AB){var AC=x("group"),AA=AC.style,i=x("image"),AE=i.style;AA.position="absolute";AA.left=0;AA.top=0;AA.width=e.width+"px";AA.height=e.height+"px";AC.coordsize=e.coordsize;AC.coordorigin=e.coordorigin;i.src=R;AC.appendChild(i);var AD=new M(i,AC,e);AD.type="image";AD.attrs.src=R;AD.attrs.x=AG;AD.attrs.y=AF;AD.attrs.w=AH;AD.attrs.h=AB;AD.setBox({x:AG,y:AF,width:AH,height:AB});e.canvas.appendChild(AC);return AD;};var k=function(e,AG,AF,AH){var AC=x("group"),AB=AC.style,AA=x("shape"),AE=AA.style,AI=x("path"),R=AI.style,i=x("textpath");AB.position="absolute";AB.left=0;AB.top=0;AB.width=e.width+"px";AB.height=e.height+"px";AC.coordsize=e.coordsize;AC.coordorigin=e.coordorigin;AI.v=["m",Math.round(AG),", ",Math.round(AF),"l",Math.round(AG)+1,", ",Math.round(AF)].join("");AI.textpathok=true;AE.width=e.width;AE.height=e.height;AB.position="absolute";AB.left=0;AB.top=0;AB.width=e.width;AB.height=e.height;i.string=AH;i.on=true;AA.appendChild(i);AA.appendChild(AI);AC.appendChild(AA);var AD=new M(i,AC,e);AD.shape=AA;AD.textpath=AI;AD.type="text";AD.attrs.text=AH;AD.attrs.x=AG;AD.attrs.y=AF;AD.attrs.w=1;AD.attrs.h=1;h(AD,{font:S.font,stroke:"none",fill:"#000"});AD.setBox();e.canvas.appendChild(AC);return AD;};var g=function(i,R){var e=this.canvas.style;this.width=i||this.width;this.height=R||this.height;e.width=this.width+"px";e.height=this.height+"px";e.clip="rect(0 "+this.width+"px "+this.height+"px 0)";this.canvas.coordsize=this.width+" "+this.height;return this;};H.createStyleSheet().addRule(".rvml","behavior:url(#default#VML)");try{if(!H.namespaces.rvml){H.namespaces.add("rvml","urn:schemas-microsoft-com:vml");}var x=function(R){return H.createElement("<rvml:"+R+' class="rvml">');};}catch(w){var x=function(R){return H.createElement("<"+R+' xmlns="urn:schemas-microsoft.com:vml" class="rvml">');};}var L=function(){var AA=j.apply(null,arguments),e=AA.container,AE=AA.x,AD=AA.y,i=AA.width,AG,AF=AA.height;if(!e){throw new Error("VML container not found.");}var AC=C.canvas=H.createElement("div"),AB=AC.style;i=parseFloat(i)||"512px";AF=parseFloat(AF)||"342px";C.width=i;C.height=AF;C.coordsize=i+" "+AF;C.coordorigin="0 0";C.span=H.createElement("span");AG=C.span.style;AC.appendChild(C.span);AG.position="absolute";AG.left="-99999px";AG.top="-99999px";AG.padding=0;AG.margin=0;AG.lineHeight=1;AG.display="inline";AB.width=i+"px";AB.height=AF+"px";AB.position="absolute";AB.clip="rect(0 "+i+"px "+AF+"px 0)";if(e==1){H.body.appendChild(AC);AB.left=AE+"px";AB.top=AD+"px";e={style:{width:i,height:AF}};}else{e.style.width=i;e.style.height=AF;if(e.firstChild){e.insertBefore(AC,e.firstChild);}else{e.appendChild(AC);}}for(var R in C){e[R]=C[R];}A.call(e,e,G.fn);e.clear=function(){while(AC.firstChild){AC.removeChild(AC.firstChild);}};e.raphael=G;return e;};C.remove=function(){this.canvas.parentNode.removeChild(this.canvas);};C.safari=function(){};}var J=(function(){if(H.addEventListener){return function(AB,i,e,R){var AA=function(AC){return e.call(R,AC);};AB.addEventListener(i,AA,false);return function(){AB.removeEventListener(i,AA,false);return true;};};}else{if(H.attachEvent){return function(AC,AA,i,e){var AB=function(AD){return i.call(e,AD||o.event);};AC.attachEvent("on"+AA,AB);var R=function(){AC.detachEvent("on"+AA,AB);return true;};if(AA=="mouseover"){AC.attachEvent("onmouseenter",AB);return function(){AC.detachEvent("onmouseenter",AB);return R();};}else{if(AA=="mouseout"){AC.attachEvent("onmouseleave",AB);return function(){AC.detachEvent("onmouseleave",AB);return R();};}}return R;};}}})();for(var t=X.length;t--;){(function(R){M.prototype[R]=function(e){if(typeof e=="function"){this.events=this.events||{};this.events[R]=this.events[R]||{};this.events[R][e]=this.events[R][e]||[];this.events[R][e].push(J(this.shape||this.node,R,e,this));}return this;};M.prototype["un"+R]=function(e){this.events&&this.events[R]&&this.events[R][e]&&this.events[R][e].length&&this.events[R][e].shift()()&&!this.events[R][e].length&&delete this.events[R][e];};})(X[t]);}C.circle=function(R,i,e){return f(this,R,i,e);};C.rect=function(R,AB,e,i,AA){return l(this,R,AB,e,i,AA);};C.ellipse=function(R,AA,i,e){return I(this,R,AA,i,e);};C.path=function(R){return y(R,this);};C.image=function(AA,R,AB,e,i){return Q(this,AA,R,AB,e,i);};C.text=function(R,i,e){return k(this,R,i,e);};C.drawGrid=function(AG,AF,AH,AD,AC,AE,AA){AA=AA||"#000";var AI=["M",AG,AF,"L",AG+AH,AF,AG+AH,AF+AD,AG,AF+AD,AG,AF],R=AD/AE,e=AH/AC;for(var AB=1;AB<AE;AB++){AI=AI.concat(["M",AG,AF+AB*R,"L",AG+AH,AF+AB*R]);}for(var AB=1;AB<AC;AB++){AI=AI.concat(["M",AG+AB*e,AF,"L",AG+AB*e,AF+AD]);}return this.path({stroke:AA,"stroke-width":1},AI.join(","));};C.set=function(R){return new K(R);};C.setSize=g;M.prototype.stop=function(){clearTimeout(this.animation_in_progress);return this;};M.prototype.scale=function(AK,AJ,AA,e){if(AK==null&&AJ==null){return{x:this._.sx,y:this._.sy,toString:function(){return +this.x.toFixed(3)+" "+(+this.y.toFixed(3));}};}AJ=AJ||AK;!+AJ&&(AJ=AK);var AO,AM,AN,AL,Aa=this.attrs;if(AK!=0){var AI=this.type=="path"?d(Aa.path):this.getBBox(),AF=AI.x+AI.width/2,AC=AI.y+AI.height/2,AZ=AK/this._.sx,AY=AJ/this._.sy;AA=(+AA||AA==0)?AA:AF;e=(+e||e==0)?e:AC;var AH=Math.round(AK/Math.abs(AK)),AE=Math.round(AJ/Math.abs(AJ)),AR=this.node.style,Ac=AA+(AF-AA)*AH*AZ,Ab=e+(AC-e)*AE*AY;switch(this.type){case"rect":case"image":var AG=Aa.width*AH*AZ,AQ=Aa.height*AE*AY,AD=Ac-AG/2,AB=Ab-AQ/2;this.attr({width:AG,height:AQ,x:AD,y:AB});break;case"circle":case"ellipse":this.attr({rx:Aa.rx*AZ,ry:Aa.ry*AY,r:Aa.r*AZ,cx:Ac,cy:Ab});break;case"path":var AT=D(Aa.path),AU=true;for(var AW=0,AP=AT.length;AW<AP;AW++){var AS=AT[AW];if(AS[0].toUpperCase()=="M"&&AU){continue;}else{AU=false;}if(G.svg&&AS[0].toUpperCase()=="A"){AS[AT[AW].length-2]*=AZ;AS[AT[AW].length-1]*=AY;AS[1]*=AZ;AS[2]*=AY;AS[5]=+(AH+AE?!!+AS[5]:!+AS[5]);}else{for(var AV=1,AX=AS.length;AV<AX;AV++){AS[AV]*=(AV%2)?AZ:AY;}}}var R=d(AT),AO=Ac-R.x-R.width/2,AM=Ab-R.y-R.height/2;AT=D(AT);AT[0][1]+=AO;AT[0][2]+=AM;this.attr({path:AT.join(" ")});break;}if(this.type in {text:1,image:1}&&(AH!=1||AE!=1)){if(this.transformations){this.transformations[2]="scale(".concat(AH,",",AE,")");this.node.setAttribute("transform",this.transformations.join(" "));AO=(AH==-1)?-Aa.x-(AG||0):Aa.x;AM=(AE==-1)?-Aa.y-(AQ||0):Aa.y;this.attr({x:AO,y:AM});Aa.fx=AH-1;Aa.fy=AE-1;}else{this.node.filterMatrix=" progid:DXImageTransform.Microsoft.Matrix(M11=".concat(AH,", M12=0, M21=0, M22=",AE,", Dx=0, Dy=0, sizingmethod='auto expand', filtertype='bilinear')");AR.filter=(this.node.filterMatrix||"")+(this.node.filterOpacity||"");}}else{if(this.transformations){this.transformations[2]="";this.node.setAttribute("transform",this.transformations.join(" "));Aa.fx=0;Aa.fy=0;}else{this.node.filterMatrix="";AR.filter=(this.node.filterMatrix||"")+(this.node.filterOpacity||"");}}Aa.scale=[AK,AJ,AA,e].join(" ");this._.sx=AK;this._.sy=AJ;}return this;};G.easing_formulas={linear:function(R){return R;},"<":function(R){return Math.pow(R,3);},">":function(R){return Math.pow(R-1,3)+1;},"<>":function(R){R=R*2;if(R<1){return Math.pow(R,3)/2;}R-=2;return(Math.pow(R,3)+2)/2;},backIn:function(e){var R=1.70158;return Math.pow(e,2)*((R+1)*e-R);},backOut:function(e){e=e-1;var R=1.70158;return Math.pow(e,2)*((R+1)*e+R)+1;},elastic:function(i){if(i==0||i==1){return i;}var e=0.3,R=e/4;return Math.pow(2,-10*i)*Math.sin((i-R)*(2*Math.PI)/e)+1;},bounce:function(AA){var e=7.5625,i=2.75,R;if(AA<(1/i)){R=e*Math.pow(AA,2);}else{if(AA<(2/i)){AA-=(1.5/i);R=e*Math.pow(AA,2)+0.75;}else{if(AA<(2.5/i)){AA-=(2.25/i);R=e*Math.pow(AA,2)+0.9375;}else{AA-=(2.625/i);R=e*Math.pow(AA,2)+0.984375;}}}return R;}};G.easing=function(e,R){return G.easing_formulas[e]?G.easing_formulas[e](R):R;};M.prototype.animate=function(AS,AK,AJ,AB){clearTimeout(this.animation_in_progress);if(typeof AJ=="function"||!AJ){AB=AJ||null;AJ="linear";}var AN={},e={},AH={},AG={x:0,y:0};for(var AL in AS){if(AL in W){AN[AL]=this.attr(AL);(typeof AN[AL]=="undefined")&&(AN[AL]=S[AL]);e[AL]=AS[AL];switch(W[AL]){case"number":AH[AL]=(e[AL]-AN[AL])/AK;break;case"colour":AN[AL]=G.getRGB(AN[AL]);var AM=G.getRGB(e[AL]);AH[AL]={r:(AM.r-AN[AL].r)/AK,g:(AM.g-AN[AL].g)/AK,b:(AM.b-AN[AL].b)/AK};break;case"path":var AC=r(AN[AL],e[AL]);AN[AL]=AC[0];e[AL]=AC[1];AH[AL]=[];for(var AP=0,AF=AN[AL].length;AP<AF;AP++){AH[AL][AP]=[0];for(var AO=1,AR=AN[AL][AP].length;AO<AR;AO++){AH[AL][AP][AO]=(e[AL][AP][AO]-AN[AL][AP][AO])/AK;}}break;case"csv":var R=(AS[AL]+"").split(z),AE=(AN[AL]+"").split(z);switch(AL){case"translation":AN[AL]=[0,0];AH[AL]=[R[0]/AK,R[1]/AK];break;case"rotation":AN[AL]=(AE[1]==R[1]&&AE[2]==R[2])?AE:[0,R[1],R[2]];AH[AL]=[(R[0]-AN[AL][0])/AK,0,0];break;case"scale":AS[AL]=R;AN[AL]=(AN[AL]+"").split(z);AH[AL]=[(R[0]-AN[AL][0])/AK,(R[1]-AN[AL][1])/AK,0,0];}e[AL]=R;}}}var AA=+new Date,AI=0,AD=this;(function AQ(){var AU=new Date-AA,Ab={},AT;if(AU<AK){pos=G.easing(AJ,AU/AK);for(var AY in AN){switch(W[AY]){case"number":AT=+AN[AY]+pos*AK*AH[AY];break;case"colour":AT="rgb("+[Math.round(AN[AY].r+pos*AK*AH[AY].r),Math.round(AN[AY].g+pos*AK*AH[AY].g),Math.round(AN[AY].b+pos*AK*AH[AY].b)].join(",")+")";break;case"path":AT=[];for(var AW=0,Ac=AN[AY].length;AW<Ac;AW++){AT[AW]=[AN[AY][AW][0]];for(var AV=1,AX=AN[AY][AW].length;AV<AX;AV++){AT[AW][AV]=+AN[AY][AW][AV]+pos*AK*AH[AY][AW][AV];}AT[AW]=AT[AW].join(" ");}AT=AT.join(" ");break;case"csv":switch(AY){case"translation":var Aa=AH[AY][0]*(AU-AI),AZ=AH[AY][1]*(AU-AI);AG.x+=Aa;AG.y+=AZ;AT=[Aa,AZ].join(" ");break;case"rotation":AT=+AN[AY][0]+pos*AK*AH[AY][0];AN[AY][1]&&(AT+=","+AN[AY][1]+","+AN[AY][2]);break;case"scale":AT=[+AN[AY][0]+pos*AK*AH[AY][0],+AN[AY][1]+pos*AK*AH[AY][1],(2 in AS[AY]?AS[AY][2]:""),(3 in AS[AY]?AS[AY][3]:"")].join(" ");}break;}if(AY=="font-size"){Ab[AY]=AT+"px";}else{Ab[AY]=AT;}}AD.attr(Ab);AD.animation_in_progress=setTimeout(AQ);G.svg&&C.safari();}else{(AG.x||AG.y)&&AD.translate(-AG.x,-AG.y);AD.attr(AS);clearTimeout(AD.animation_in_progress);G.svg&&C.safari();(typeof AB=="function")&&AB.call(AD);}AI=AU;})();return this;};M.prototype.translate=function(R,i){if(R==null){return{x:this._.tx,y:this._.ty};}this._.tx+=+R;this._.ty+=+i;switch(this.type){case"circle":case"ellipse":this.attr({cx:+R+this.attrs.cx,cy:+i+this.attrs.cy});break;case"rect":case"image":case"text":this.attr({x:+R+this.attrs.x,y:+i+this.attrs.y});break;case"path":var e=D(this.attrs.path);e[0][1]+=+R;e[0][2]+=+i;this.attr({path:e});break;}return this;};var K=function(R){this.items=[];this.length=0;if(R){for(var e=0,AA=R.length;e<AA;e++){if(R[e]&&(R[e].constructor==M||R[e].constructor==K)){this[this.items.length]=this.items[this.items.length]=R[e];this.length++;}}}};K.prototype.push=function(){var AB,R;for(var e=0,AA=arguments.length;e<AA;e++){AB=arguments[e];if(AB&&(AB.constructor==M||AB.constructor==K)){R=this.items.length;this[R]=this.items[R]=AB;this.length++;}}return this;};K.prototype.pop=function(AA){var e=this.items.splice(AA,1)[0];for(var R=AA,i=this.items.length;R<i;R++){this[R]=this[R+1];}delete this[i+1];this.length--;return e;};for(var u in M.prototype){K.prototype[u]=(function(R){return function(){for(var e=0,AA=this.items.length;e<AA;e++){this.items[e][R].apply(this.items[e],arguments);}return this;};})(u);}K.prototype.attr=function(e,AD){if(e&&G.isArray(e)&&typeof e[0]=="object"){for(var R=0,AC=e.length;R<AC;R++){this.items[R].attr(e[R]);}}else{for(var AA=0,AB=this.items.length;AA<AB;AA++){this.items[AA].attr.apply(this.items[AA],arguments);}}return this;};K.prototype.getBBox=function(){var R=[],AD=[],e=[],AB=[];for(var AA=this.items.length;AA--;){var AC=this.items[AA].getBBox();R.push(AC.x);AD.push(AC.y);e.push(AC.x+AC.width);AB.push(AC.y+AC.height);}R=Math.min.apply(Math,R);AD=Math.min.apply(Math,AD);return{x:R,y:AD,width:Math.max.apply(Math,e)-R,height:Math.max.apply(Math,AB)-AD};};G.registerFont=function(e){if(!e.face){return e;}this.fonts=this.fonts||{};var AA={w:e.w,face:{},glyphs:{}},i=e.face["font-family"];for(var AD in e.face){AA.face[AD]=e.face[AD];}if(this.fonts[i]){this.fonts[i].push(AA);}else{this.fonts[i]=[AA];}if(!e.svg){AA.face["units-per-em"]=parseInt(e.face["units-per-em"],10);for(var AB in e.glyphs){var AC=e.glyphs[AB];AA.glyphs[AB]={w:AC.w,k:{},d:AC.d&&"M"+AC.d.replace(/[mlcxtrv]/g,function(AE){return{l:"L",c:"C",x:"z",t:"m",r:"l",v:"c"}[AE]||"M";})+"z"};if(AC.k){for(var R in AC.k){AA.glyphs[AB].k[R]=AC.k[R];}}}}return e;};C.getFont=function(AF,AG,e,AB){AB=AB||"normal";e=e||"normal";AG=+AG||{normal:400,bold:700,lighter:300,bolder:800}[AG]||400;var AC=G.fonts[AF];if(!AC){var AA=new RegExp("(^|\\s)"+AF.replace(/[^\w\d\s+!~.:_-]/g,"")+"(\\s|$)","i");for(var R in G.fonts){if(AA.test(R)){AC=G.fonts[R];break;}}}var AD;if(AC){for(var AE=0,AH=AC.length;AE<AH;AE++){AD=AC[AE];if(AD.face["font-weight"]==AG&&(AD.face["font-style"]==e||!AD.face["font-style"])&&AD.face["font-stretch"]==AB){break;}}}return AD;};C.print=function(AH,AG,AE,e,AL){var AC=this.set(),AF=(AE+"").split(""),R=0,AK="",AB;if(e){AB=(AL||16)/e.face["units-per-em"];for(var AD=0,AI=AF.length;AD<AI;AD++){var AA=AD&&e.glyphs[AF[AD-1]]||{},AJ=e.glyphs[AF[AD]];R+=AD?(AA.w||e.w)+(AA.k&&AA.k[AF[AD]]||0):0;AJ&&AJ.d&&AC.push(this.path({fill:"#000",stroke:"none"},AJ.d).translate(R,0));}AC.scale(AB,AB,0,AG).translate(AH,(AL||16)/2);}return AC;};G.ninja=function(){var R=window.Raphael;if(s.was){window.Raphael=s.is;}else{try{delete window.Raphael;}catch(i){window.Raphael=void (0);}}return R;};G.el=M.prototype;return G;})();