/*
 * Raphael 1.0 - JavaScript Vector Library
 *
 * Copyright (c) 2008 - 2009 Dmitry Baranovskiy (http://raphaeljs.com)
 * Licensed under the MIT (http://www.opensource.org/licenses/mit-license.php) license.
 */
window.Raphael=(function(){var x=/[, ]+/,F=document,l=window,p={was:"Raphael" in window,is:window.Raphael},E=function(){return J.apply(E,arguments);},B={},O={cx:0,cy:0,fill:"#fff","fill-opacity":1,font:'10px "Arial"',"font-family":'"Arial"',"font-size":"10","font-style":"normal","font-weight":400,gradient:0,height:0,href:"http://raphaeljs.com/",opacity:1,path:"M0,0",r:0,rotation:0,rx:0,ry:0,scale:"1 1",src:"",stroke:"#000","stroke-dasharray":"","stroke-linecap":"butt","stroke-linejoin":"butt","stroke-miterlimit":0,"stroke-opacity":1,"stroke-width":1,target:"_blank","text-anchor":"middle",title:"Raphael",translation:"0 0",width:0,x:0,y:0},T={cx:"number",cy:"number",fill:"colour","fill-opacity":"number","font-size":"number",height:"number",opacity:"number",path:"path",r:"number",rotation:"csv",rx:"number",ry:"number",scale:"csv",stroke:"colour","stroke-opacity":"number","stroke-width":"number",translation:"csv",width:"number",x:"number",y:"number"},U=["click","dblclick","mousedown","mousemove","mouseout","mouseover","mouseup"];E.version="1.0";E.type=(window.SVGAngle||document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1")?"SVG":"VML");E.svg=!(E.vml=E.type=="VML");E.idGenerator=0;E.fn={};E.isArray=function(R){return Object.prototype.toString.call(R)=="[object Array]";};E.setWindow=function(R){l=R;F=l.document;};E.hsb2rgb=w(function(AE,AC,AI){if(typeof AE=="object"&&"h" in AE&&"s" in AE&&"b" in AE){AI=AE.b;AC=AE.s;AE=AE.h;}var z,AA,AJ;if(AI==0){return{r:0,g:0,b:0,hex:"#000"};}if(AE>1||AC>1||AI>1){AE/=255;AC/=255;AI/=255;}var AB=Math.floor(AE*6),AF=(AE*6)-AB,y=AI*(1-AC),e=AI*(1-(AC*AF)),AK=AI*(1-(AC*(1-AF)));z=[AI,e,y,y,AK,AI,AI][AB];AA=[AK,AI,AI,e,y,y,AK][AB];AJ=[y,y,AK,AI,AI,e,y][AB];z*=255;AA*=255;AJ*=255;var AG={r:z,g:AA,b:AJ},R=Math.round(z).toString(16),AD=Math.round(AA).toString(16),AH=Math.round(AJ).toString(16);if(R.length==1){R="0"+R;}if(AD.length==1){AD="0"+AD;}if(AH.length==1){AH="0"+AH;}AG.hex="#"+R+AD+AH;return AG;},E);E.rgb2hsb=w(function(R,e,AC){if(typeof R=="object"&&"r" in R&&"g" in R&&"b" in R){AC=R.b;e=R.g;R=R.r;}if(typeof R=="string"){var AE=E.getRGB(R);R=AE.r;e=AE.g;AC=AE.b;}if(R>1||e>1||AC>1){R/=255;e/=255;AC/=255;}var AB=Math.max(R,e,AC),i=Math.min(R,e,AC),z,y,AA=AB;if(i==AB){return{h:0,s:0,b:AB};}else{var AD=(AB-i);y=AD/AB;if(R==AB){z=(e-AC)/AD;}else{if(e==AB){z=2+((AC-R)/AD);}else{z=4+((R-e)/AD);}}z/=6;if(z<0){z+=1;}if(z>1){z-=1;}}return{h:z,s:y,b:AA};},E);E._path2string=function(){var y="",AB;for(var e=0,z=this.length;e<z;e++){for(var R=0,AA=this[e].length;R<AA;R++){y+=this[e][R];R&&R!=AA-1&&(y+=",");}e!=z-1&&(y+="\n");}return y.replace(/,(?=-)/g,"");};function w(y,e,R){function i(){var z=Array.prototype.splice.call(arguments,0,arguments.length),AA=z.join("\u25ba");i.cache=i.cache||{};i.count=i.count||[];if(AA in i.cache){return R?R(i.cache[AA]):i.cache[AA];}if(i.count.length>1000){delete i.cache[i.count.unshift()];}i.count.push(AA);i.cache[AA]=y.apply(e,z);return R?R(i.cache[AA]):i.cache[AA];}return i;}E.getRGB=w(function(R){var AE={aliceblue:"#f0f8ff",amethyst:"#96c",antiquewhite:"#faebd7",aqua:"#0ff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000",blanchedalmond:"#ffebcd",blue:"#00f",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#0ff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#f0f",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgreen:"#90ee90",lightgrey:"#d3d3d3",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#789",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#0f0",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#f0f",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370db",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#db7093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#f00",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#fff",whitesmoke:"#f5f5f5",yellow:"#ff0",yellowgreen:"#9acd32"},AA;if((R+"").toLowerCase() in AE){R=AE[R.toString().toLowerCase()];}if(!R){return{r:0,g:0,b:0,hex:"#000"};}if(R=="none"){return{r:-1,g:-1,b:-1,hex:"none"};}var i,y,AD,AB=(R+"").match(/^\s*((#[a-f\d]{6})|(#[a-f\d]{3})|rgb\(\s*([\d\.]+\s*,\s*[\d\.]+\s*,\s*[\d\.]+)\s*\)|rgb\(\s*([\d\.]+%\s*,\s*[\d\.]+%\s*,\s*[\d\.]+%)\s*\)|hs[bl]\(\s*([\d\.]+\s*,\s*[\d\.]+\s*,\s*[\d\.]+)\s*\)|hs[bl]\(\s*([\d\.]+%\s*,\s*[\d\.]+%\s*,\s*[\d\.]+%)\s*\))\s*$/i);if(AB){if(AB[2]){AD=parseInt(AB[2].substring(5),16);y=parseInt(AB[2].substring(3,5),16);i=parseInt(AB[2].substring(1,3),16);}if(AB[3]){AD=parseInt(AB[3].substring(3)+AB[3].substring(3),16);y=parseInt(AB[3].substring(2,3)+AB[3].substring(2,3),16);i=parseInt(AB[3].substring(1,2)+AB[3].substring(1,2),16);}if(AB[4]){AB=AB[4].split(/\s*,\s*/);i=parseFloat(AB[0]);y=parseFloat(AB[1]);AD=parseFloat(AB[2]);}if(AB[5]){AB=AB[5].split(/\s*,\s*/);i=parseFloat(AB[0])*2.55;y=parseFloat(AB[1])*2.55;AD=parseFloat(AB[2])*2.55;}if(AB[6]){AB=AB[6].split(/\s*,\s*/);i=parseFloat(AB[0]);y=parseFloat(AB[1]);AD=parseFloat(AB[2]);return E.hsb2rgb(i,y,AD);}if(AB[7]){AB=AB[7].split(/\s*,\s*/);i=parseFloat(AB[0])*2.55;y=parseFloat(AB[1])*2.55;AD=parseFloat(AB[2])*2.55;return E.hsb2rgb(i,y,AD);}var AB={r:i,g:y,b:AD},e=Math.round(i).toString(16),z=Math.round(y).toString(16),AC=Math.round(AD).toString(16);(e.length==1)&&(e="0"+e);(z.length==1)&&(z="0"+z);(AC.length==1)&&(AC="0"+AC);AB.hex="#"+e+z+AC;AA=AB;}else{AA={r:-1,g:-1,b:-1,hex:"none"};}return AA;},E);E.getColor=function(e){var i=this.getColor.start=this.getColor.start||{h:0,s:1,b:e||0.75},R=this.hsb2rgb(i.h,i.s,i.b);i.h+=0.075;if(i.h>1){i.h=0;i.s-=0.2;if(i.s<=0){this.getColor.start={h:0,s:1,b:i.b};}}return R.hex;};E.getColor.reset=function(){delete this.start;};E.parsePathString=w(function(R){if(!R){return null;}var i={a:7,c:6,h:1,l:2,m:2,q:4,s:4,t:2,v:1,z:0},e=[];if(E.isArray(R)&&E.isArray(R[0])){e=S(R);}if(!e.length){(R+"").replace(/([achlmqstvz])[\s,]*((-?\d*\.?\d*(?:e[-+]?\d+)?\s*,?\s*)+)/ig,function(z,y,AC){var AB=[],AA=y.toLowerCase();AC.replace(/(-?\d*\.?\d*(?:e[-+]?\d+)?)\s*,?\s*/ig,function(AE,AD){AD&&AB.push(+AD);});while(AB.length>=i[AA]){e.push([y].concat(AB.splice(0,i[AA])));if(!i[AA]){break;}}});}e.toString=E._path2string;return e;});var a=w(function(AG){AG=o(AG);var AD=0,AC=0,z=[],e=[];for(var AA=0,AF=AG.length;AA<AF;AA++){if(AG[AA][0]=="M"){AD=AG[AA][1];AC=AG[AA][2];z.push(AD);e.push(AC);}else{var AB=j(AD,AC,AG[AA][1],AG[AA][2],AG[AA][3],AG[AA][4],AG[AA][5],AG[AA][6]);z=z.concat(AB.min.x,AB.max.x);e=e.concat(AB.min.y,AB.max.y);}}var R=Math.min.apply(0,z),AE=Math.min.apply(0,e);return{x:R,y:AE,width:Math.max.apply(0,z)-R,height:Math.max.apply(0,e)-AE};}),S=function(AB){var y=[];if(!E.isArray(AB)||!E.isArray(AB&&AB[0])){AB=E.parsePathString(AB);}for(var e=0,z=AB.length;e<z;e++){y[e]=[];for(var R=0,AA=AB[e].length;R<AA;R++){y[e][R]=AB[e][R];}}y.toString=E._path2string;return y;},C=w(function(AA){if(!E.isArray(AA)||!E.isArray(AA&&AA[0])){AA=E.parsePathString(AA);}var AG=[],AI=0,AH=0,AL=0,AK=0,z=0;if(AA[0][0]=="M"){AI=AA[0][1];AH=AA[0][2];AL=AI;AK=AH;z++;AG.push(["M",AI,AH]);}for(var AD=z,AM=AA.length;AD<AM;AD++){var R=AG[AD]=[],AJ=AA[AD];if(AJ[0]!=AJ[0].toLowerCase()){R[0]=AJ[0].toLowerCase();switch(R[0]){case"a":R[1]=AJ[1];R[2]=AJ[2];R[3]=AJ[3];R[4]=AJ[4];R[5]=AJ[5];R[6]=+(AJ[6]-AI).toFixed(3);R[7]=+(AJ[7]-AH).toFixed(3);break;case"v":R[1]=+(AJ[1]-AH).toFixed(3);break;case"m":AL=AJ[1];AK=AJ[2];default:for(var AC=1,AE=AJ.length;AC<AE;AC++){R[AC]=+(AJ[AC]-((AC%2)?AI:AH)).toFixed(3);}}}else{R=AG[AD]=[];if(AJ[0]=="m"){AL=AJ[1]+AI;AK=AJ[2]+AH;}for(var AB=0,e=AJ.length;AB<e;AB++){AG[AD][AB]=AJ[AB];}}var AF=AG[AD].length;switch(AG[AD][0]){case"z":AI=AL;AH=AK;break;case"h":AI+=+AG[AD][AF-1];break;case"v":AH+=+AG[AD][AF-1];break;default:AI+=+AG[AD][AF-2];AH+=+AG[AD][AF-1];}}AG.toString=E._path2string;return AG;},0,S),V=w(function(AA){if(!E.isArray(AA)||!E.isArray(AA&&AA[0])){AA=E.parsePathString(AA);}var AF=[],AH=0,AG=0,AK=0,AJ=0,z=0;if(AA[0][0]=="M"){AH=+AA[0][1];AG=+AA[0][2];AK=AH;AJ=AG;z++;AF[0]=["M",AH,AG];}for(var AD=z,AL=AA.length;AD<AL;AD++){var R=AF[AD]=[],AI=AA[AD];if(AI[0]!=(AI[0]+"").toUpperCase()){R[0]=(AI[0]+"").toUpperCase();switch(R[0]){case"A":R[1]=AI[1];R[2]=AI[2];R[3]=AI[3];R[4]=AI[4];R[5]=AI[5];R[6]=+(AI[6]+AH);R[7]=+(AI[7]+AG);break;case"V":R[1]=+AI[1]+AG;break;case"H":R[1]=+AI[1]+AH;break;case"M":AK=+AI[1]+AH;AJ=+AI[2]+AG;default:for(var AC=1,AE=AI.length;AC<AE;AC++){R[AC]=+AI[AC]+((AC%2)?AH:AG);}}}else{for(var AB=0,e=AI.length;AB<e;AB++){AF[AD][AB]=AI[AB];}}switch(R[0]){case"Z":AH=AK;AG=AJ;break;case"H":AH=R[1];break;case"V":AG=R[1];break;default:AH=AF[AD][AF[AD].length-2];AG=AF[AD][AF[AD].length-1];}}AF.toString=E._path2string;return AF;},null,S),D=function(e,y,R,i){return[e,y,R,i,R,i];},W=function(e,y,AA,z,R,i){return[2/3*e+1/3*AA,2/3*y+1/3*z,2/3*e+1/3*R,2/3*y+1/3*i,R,i];},P=function(AK,Ao,AT,AR,AL,AF,AA,AJ,An,AM){var AQ=Math.PI*120/180,R=Math.PI/180*(+AL||0),AX=[],AU,Ak=w(function(Ap,As,i){var Ar=Ap*Math.cos(i)-As*Math.sin(i),Aq=Ap*Math.sin(i)+As*Math.cos(i);return{x:Ar,y:Aq};});if(!AM){AU=Ak(AK,Ao,-R);AK=AU.x;Ao=AU.y;AU=Ak(AJ,An,-R);AJ=AU.x;An=AU.y;var e=Math.cos(Math.PI/180*AL),AH=Math.sin(Math.PI/180*AL),AZ=(AK-AJ)/2,AY=(Ao-An)/2;AT=Math.max(AT,Math.abs(AZ));AR=Math.max(AR,Math.abs(AY));var z=AT*AT,Ac=AR*AR,Ae=(AF==AA?-1:1)*Math.sqrt((z*Ac-z*AY*AY-Ac*AZ*AZ)/(z*AY*AY+Ac*AZ*AZ)),AO=Ae*AT*AY/AR+(AK+AJ)/2,AN=Ae*-AR*AZ/AT+(Ao+An)/2,AE=Math.asin((Ao-AN)/AR),AD=Math.asin((An-AN)/AR);AE=AK<AO?Math.PI-AE:AE;AD=AJ<AO?Math.PI-AD:AD;AE<0&&(AE=Math.PI*2+AE);AD<0&&(AD=Math.PI*2+AD);if(AA&&AE>AD){AE=AE-Math.PI*2;}if(!AA&&AD>AE){AD=AD-Math.PI*2;}}else{AE=AM[0];AD=AM[1];AO=AM[2];AN=AM[3];}var AI=AD-AE;if(Math.abs(AI)>AQ){var AP=AD,AS=AJ,AG=An;AD=AE+AQ*(AA&&AD>AE?1:-1);AJ=AO+AT*Math.cos(AD);An=AN+AR*Math.sin(AD);AX=P(AJ,An,AT,AR,AL,0,AA,AS,AG,[AD,AP,AO,AN]);}var AC=Math.cos(AE),Am=Math.sin(AE),AB=Math.cos(AD),Al=Math.sin(AD),AI=AD-AE,Aa=Math.tan(AI/4),Ad=4/3*AT*Aa,Ab=4/3*AR*Aa,Aj=[AK,Ao],Ai=[AK+Ad*Am,Ao-Ab*AC],Ah=[AJ+Ad*Al,An-Ab*AB],Af=[AJ,An];Ai[0]=2*Aj[0]-Ai[0];Ai[1]=2*Aj[1]-Ai[1];if(AM){return[Ai,Ah,Af].concat(AX);}else{AX=[Ai,Ah,Af].concat(AX).join(",").split(",");var AV=[];for(var Ag=0,AW=AX.length;Ag<AW;Ag++){AV[Ag]=Ag%2?Ak(AX[Ag-1],AX[Ag],R).y:Ak(AX[Ag],AX[Ag+1],R).x;}return AV;}},Z=w(function(e,R,AO,AM,AB,AA,AD,AC,AI){var AG=Math.pow(1-AI,3)*e+Math.pow(1-AI,2)*3*AI*AO+(1-AI)*3*AI*AI*AB+Math.pow(AI,3)*AD,AE=Math.pow(1-AI,3)*R+Math.pow(1-AI,2)*3*AI*AM+(1-AI)*3*AI*AI*AA+Math.pow(AI,3)*AC,AK=e+2*AI*(AO-e)+AI*AI*(AB-2*AO+e),AJ=R+2*AI*(AM-R)+AI*AI*(AA-2*AM+R),AN=AO+2*AI*(AB-AO)+AI*AI*(AD-2*AB+AO),AL=AM+2*AI*(AA-AM)+AI*AI*(AC-2*AA+AM),AH=(1-AI)*e+AI*AO,AF=(1-AI)*R+AI*AM,z=(1-AI)*AB+AI*AD,i=(1-AI)*AA+AI*AC;return{x:AG,y:AE,m:{x:AK,y:AJ},n:{x:AN,y:AL},start:{x:AH,y:AF},end:{x:z,y:i}};}),j=w(function(e,R,z,i,AM,AL,AI,AF){var AK=(AM-2*z+e)-(AI-2*AM+z),AH=2*(z-e)-2*(AM-z),AE=e-z,AC=(-AH+Math.sqrt(AH*AH-4*AK*AE))/2/AK,AA=(-AH-Math.sqrt(AH*AH-4*AK*AE))/2/AK,AG=[R,AF],AJ=[e,AI],AD=Z(e,R,z,i,AM,AL,AI,AF,AC>0&&AC<1?AC:0),AB=Z(e,R,z,i,AM,AL,AI,AF,AA>0&&AA<1?AA:0);AJ=AJ.concat(AD.x,AB.x);AG=AG.concat(AD.y,AB.y);AK=(AL-2*i+R)-(AF-2*AL+i);AH=2*(i-R)-2*(AL-i);AE=R-i;AC=(-AH+Math.sqrt(AH*AH-4*AK*AE))/2/AK;AA=(-AH-Math.sqrt(AH*AH-4*AK*AE))/2/AK;AD=Z(e,R,z,i,AM,AL,AI,AF,AC>0&&AC<1?AC:0);AB=Z(e,R,z,i,AM,AL,AI,AF,AA>0&&AA<1?AA:0);AJ=AJ.concat(AD.x,AB.x);AG=AG.concat(AD.y,AB.y);return{min:{x:Math.min.apply(Math,AJ),y:Math.min.apply(Math,AG)},max:{x:Math.max.apply(Math,AJ),y:Math.max.apply(Math,AG)}};}),o=w(function(AK,AF){var z=V(AK),AG=AF&&V(AF),AH={x:0,y:0,bx:0,by:0,X:0,Y:0},R={x:0,y:0,bx:0,by:0,X:0,Y:0},AB=function(AL,AM){if(!AL){return["C",AM.x,AM.y,AM.x,AM.y,AM.x,AM.y];}switch(AL[0]){case"M":AM.X=AL[1];AM.Y=AL[2];break;case"A":AL=["C"].concat(P(AM.x,AM.y,AL[1],AL[2],AL[3],AL[4],AL[5],AL[6],AL[7]));break;case"S":var i=AM.x+(AM.x-(AM.bx||AM.x)),AN=AM.y+(AM.y-(AM.by||AM.y));AL=["C",i,AN,AL[1],AL[2],AL[3],AL[4]];break;case"T":var i=AM.x+(AM.x-(AM.bx||AM.x)),AN=AM.y+(AM.y-(AM.by||AM.y));AL=["C"].concat(W(AM.x,AM.y,i,AN,AL[1],AL[2]));break;case"Q":AL=["C"].concat(W(AM.x,AM.y,AL[1],AL[2],AL[3],AL[4]));break;case"L":AL=["C"].concat(D(AM.x,AM.y,AL[1],AL[2]));break;case"H":AL=["C"].concat(D(AM.x,AM.y,AL[1],AM.y));break;case"V":AL=["C"].concat(D(AM.x,AM.y,AM.x,AL[1]));break;case"Z":AL=["C"].concat(D(AM.x,AM.y,AM.X,AM.Y));break;}return AL;},e=function(AL,AM){if(AL[AM].length>7){AL[AM].shift();var AN=AL[AM];while(AN.length){AL.splice(AM++,0,["C"].concat(AN.splice(0,6)));}AL.splice(AM,1);AI=Math.max(z.length,AG&&AG.length||0);}},y=function(AP,AO,AM,AL,AN){if(AP&&AO&&AP[AN][0]=="M"&&AO[AN][0]!="M"){AO.splice(AN,0,["M",AL.x,AL.y]);AM.bx=0;AM.by=0;AM.x=AP[AN][1];AM.y=AP[AN][2];AI=Math.max(z.length,AG&&AG.length||0);}};for(var AD=0,AI=Math.max(z.length,AG&&AG.length||0);AD<AI;AD++){z[AD]=AB(z[AD],AH);e(z,AD);AG&&(AG[AD]=AB(AG[AD],R));AG&&e(AG,AD);y(z,AG,AH,R,AD);y(AG,z,R,AH,AD);var AC=z[AD],AJ=AG&&AG[AD],AA=AC.length,AE=AG&&AJ.length;AH.bx=AC[AA-4]||0;AH.by=AC[AA-3]||0;AH.x=AC[AA-2];AH.y=AC[AA-1];R.bx=AG&&(AJ[AE-4]||0);R.by=AG&&(AJ[AE-3]||0);R.x=AG&&AJ[AE-2];R.y=AG&&AJ[AE-1];}return AG?[z,AG]:z;},null,S),L=w(function(AG){if(typeof AG=="string"){AG=AG.split(/\s*\-\s*/);var y=AG.shift();if(y.toLowerCase()=="v"){y=90;}else{if(y.toLowerCase()=="h"){y=0;}else{y=parseFloat(y);}}y=-y;var AE={angle:y,type:"linear",dots:[],vector:[0,0,Math.cos(y*Math.PI/180).toFixed(3),Math.sin(y*Math.PI/180).toFixed(3)]},AF=1/(Math.max(Math.abs(AE.vector[2]),Math.abs(AE.vector[3]))||1);AE.vector[2]*=AF;AE.vector[3]*=AF;if(AE.vector[2]<0){AE.vector[0]=-AE.vector[2];AE.vector[2]=0;}if(AE.vector[3]<0){AE.vector[1]=-AE.vector[3];AE.vector[3]=0;}AE.vector[0]=AE.vector[0];AE.vector[1]=AE.vector[1];AE.vector[2]=AE.vector[2];AE.vector[3]=AE.vector[3];for(var AB=0,AH=AG.length;AB<AH;AB++){var R={},AD=AG[AB].match(/^([^:]*):?([\d\.]*)/);R.color=E.getRGB(AD[1]).hex;AD[2]&&(R.offset=AD[2]+"%");AE.dots.push(R);}for(var AB=1,AH=AE.dots.length-1;AB<AH;AB++){if(!AE.dots[AB].offset){var e=parseFloat(AE.dots[AB-1].offset||0),z=false;for(var AA=AB+1;AA<AH;AA++){if(AE.dots[AA].offset){z=AE.dots[AA].offset;break;}}if(!z){z=100;AA=AH;}z=parseFloat(z);var AC=(z-e)/(AA-AB+1);for(;AB<AA;AB++){e+=AC;AE.dots[AB].offset=e+"%";}}}return AE;}else{return AG;}}),f=function(){var i,e,AA,z,R;if(typeof arguments[0]=="string"||typeof arguments[0]=="object"){if(typeof arguments[0]=="string"){i=F.getElementById(arguments[0]);}else{i=arguments[0];}if(i.tagName){if(arguments[1]==null){return{container:i,width:i.style.pixelWidth||i.offsetWidth,height:i.style.pixelHeight||i.offsetHeight};}else{return{container:i,width:arguments[1],height:arguments[2]};}}}else{if(typeof arguments[0]=="number"&&arguments.length>3){return{container:1,x:arguments[0],y:arguments[1],width:arguments[2],height:arguments[3]};}}},A=function(R,i){var e=this;for(var y in i){if(i.hasOwnProperty(y)&&!(y in R)){switch(typeof i[y]){case"function":(function(z){R[y]=R===e?z:function(){return z.apply(e,arguments);};})(i[y]);break;case"object":R[y]=R[y]||{};A.call(this,R[y],i[y]);break;default:R[y]=i[y];break;}}}};if(E.svg){var n=function(R){return +R+(Math.floor(R)==R)*0.5;};var Y=function(AA){for(var e=0,y=AA.length;e<y;e++){if(AA[e][0].toLowerCase()!="a"){for(var R=1,z=AA[e].length;R<z;R++){AA[e][R]=n(AA[e][R]);}}else{AA[e][6]=n(AA[e][6]);AA[e][7]=n(AA[e][7]);}}return AA;};E.toString=function(){return"Your browser supports SVG.\nYou are running Rapha\u00ebl "+this.version;};var v=function(R,y){var e=F.createElementNS(y.svgns,"path");y.canvas&&y.canvas.appendChild(e);var i=new K(e,y);i.type="path";d(i,{fill:"none",stroke:"#000",path:R});return i;};var m=function(AC,AA,AD){AA=L(AA);var z=F.createElementNS(AD.svgns,(AA.type||"linear")+"Gradient");z.id="r"+(E.idGenerator++).toString(36);if(AA.vector&&AA.vector.length){z.setAttribute("x1",AA.vector[0]);z.setAttribute("y1",AA.vector[1]);z.setAttribute("x2",AA.vector[2]);z.setAttribute("y2",AA.vector[3]);}AD.defs.appendChild(z);var AB=true;for(var e=0,y=AA.dots.length;e<y;e++){var R=F.createElementNS(AD.svgns,"stop");if(AA.dots[e].offset){AB=false;}R.setAttribute("offset",AA.dots[e].offset?AA.dots[e].offset:(e==0)?"0%":"100%");R.setAttribute("stop-color",E.getRGB(AA.dots[e].color).hex||"#fff");z.appendChild(R);}if(AB&&typeof AA.dots[y-1].opacity!="undefined"){R.setAttribute("stop-opacity",AA.dots[y-1].opacity);}AC.setAttribute("fill","url(#"+z.id+")");AC.style.fill="";AC.style.opacity=1;AC.style.fillOpacity=1;AC.setAttribute("opacity",1);AC.setAttribute("fill-opacity",1);};var Q=function(e){var R=e.getBBox();e.pattern.setAttribute("patternTransform","translate(".concat(R.x,",",R.y,")"));};var d=function(AF,AM){var AI={"":[0],none:[0],"-":[3,1],".":[1,1],"-.":[3,1,1,1],"-..":[3,1,1,1,1,1],". ":[1,3],"- ":[4,3],"--":[8,3],"- .":[4,3,1,3],"--.":[8,3,1,3],"--..":[8,3,1,3,1,3]},AK=AF.node,AG=AF.attrs,AC=AF.attr("rotation"),z=function(AU,AT){AT=AI[(AT+"").toLowerCase()];if(AT){var AR=AU.attrs["stroke-width"]||"1",AO={round:AR,square:AR,butt:0}[AU.attrs["stroke-linecap"]||AM["stroke-linecap"]]||0,AS=[];for(var AP=0,AQ=AT.length;AP<AQ;AP++){AS.push(AT[AP]*AR+((AP%2)?1:-1)*AO);}AT=AS.join(",");AK.setAttribute("stroke-dasharray",AT);}};parseInt(AC,10)&&AF.rotate(0,true);for(var AJ in AM){if(!(AJ in O)){continue;}var AH=AM[AJ];AG[AJ]=AH;switch(AJ){case"href":case"title":case"target":var AL=AK.parentNode;if(AL.tagName.toLowerCase()!="a"){var i=F.createElementNS(AF.paper.svgns,"a");AL.insertBefore(i,AK);i.appendChild(AK);AL=i;}AL.setAttributeNS(AF.paper.xlink,AJ,AH);break;case"path":if(AH&&AF.type=="path"){AG.path=Y(V(AH));AK.setAttribute("d",AG.path);}case"width":AK.setAttribute(AJ,AH);if(AG.fx){AJ="x";AH=AG.x;}else{break;}case"x":if(AG.fx){AH=-AG.x-(AG.width||0);}case"rx":case"cx":AK.setAttribute(AJ,AH);AF.pattern&&Q(AF);break;case"height":AK.setAttribute(AJ,AH);if(AG.fy){AJ="y";AH=AG.y;}else{break;}case"y":if(AG.fy){AH=-AG.y-(AG.height||0);}case"ry":case"cy":AK.setAttribute(AJ,AH);AF.pattern&&Q(AF);break;case"r":if(AF.type=="rect"){AK.setAttribute("rx",AH);AK.setAttribute("ry",AH);}else{AK.setAttribute(AJ,AH);}break;case"src":if(AF.type=="image"){AK.setAttributeNS(AF.paper.xlink,"href",AH);}break;case"stroke-width":AK.style.strokeWidth=AH;AK.setAttribute(AJ,AH);if(AG["stroke-dasharray"]){z(AF,AG["stroke-dasharray"]);}break;case"stroke-dasharray":z(AF,AH);break;case"rotation":AC=AH;AF.rotate(AH,true);break;case"translation":var AA=(AH+"").split(x);AF.translate((+AA[0]+1||2)-1,(+AA[1]+1||2)-1);break;case"scale":var AA=(AH+"").split(x);AF.scale(+AA[0]||1,+AA[1]||+AA[0]||1,+AA[2]||null,+AA[3]||null);break;case"fill":var y=(AH+"").match(/^url\(['"]?([^\)]+)['"]?\)$/i);if(y){var e=F.createElementNS(AF.paper.svgns,"pattern"),AE=F.createElementNS(AF.paper.svgns,"image");e.id="r"+(E.idGenerator++).toString(36);e.setAttribute("x",0);e.setAttribute("y",0);e.setAttribute("patternUnits","userSpaceOnUse");AE.setAttribute("x",0);AE.setAttribute("y",0);AE.setAttributeNS(AF.paper.xlink,"href",y[1]);e.appendChild(AE);var AN=F.createElement("img");AN.style.position="absolute";AN.style.top="-9999em";AN.style.left="-9999em";AN.onload=function(){e.setAttribute("width",this.offsetWidth);e.setAttribute("height",this.offsetHeight);AE.setAttribute("width",this.offsetWidth);AE.setAttribute("height",this.offsetHeight);F.body.removeChild(this);B.safari();};F.body.appendChild(AN);AN.src=y[1];AF.paper.defs.appendChild(e);AK.style.fill="url(#"+e.id+")";AK.setAttribute("fill","url(#"+e.id+")");AF.pattern=e;AF.pattern&&Q(AF);break;}delete AM.gradient;delete AG.gradient;if(typeof AG.opacity!="undefined"&&typeof AM.opacity=="undefined"){AK.style.opacity=AG.opacity;AK.setAttribute("opacity",AG.opacity);}if(typeof AG["fill-opacity"]!="undefined"&&typeof AM["fill-opacity"]=="undefined"){AK.style.fillOpacity=AG["fill-opacity"];AK.setAttribute("fill-opacity",AG["fill-opacity"]);}case"stroke":AK.style[AJ]=E.getRGB(AH).hex;AK.setAttribute(AJ,E.getRGB(AH).hex);break;case"gradient":m(AK,AH,AF.paper);break;case"opacity":case"fill-opacity":if(AG.gradient){var R=F.getElementById(AK.getAttribute("fill").replace(/^url\(#|\)$/g,""));if(R){var AB=R.getElementsByTagName("stop");AB[AB.length-1].setAttribute("stop-opacity",AH);}break;}default:AJ=="font-size"&&(AH=parseInt(AH,10)+"px");var AD=AJ.replace(/(\-.)/g,function(AO){return AO.substring(1).toUpperCase();});AK.style[AD]=AH;AK.setAttribute(AJ,AH);break;}}s(AF,AM);parseInt(AC,10)&&AF.rotate(AC,true);};var k=1.2;var s=function(R,z){if(R.type!="text"||!("text" in z||"font" in z||"font-size" in z||"x" in z||"y" in z)){return ;}var AE=R.attrs,e=R.node,AG=e.firstChild?parseInt(F.defaultView.getComputedStyle(e.firstChild,"").getPropertyValue("font-size"),10):10;if("text" in z){while(e.firstChild){e.removeChild(e.firstChild);}var y=(z.text+"").split("\n");for(var AA=0,AF=y.length;AA<AF;AA++){var AC=F.createElementNS(R.paper.svgns,"tspan");AA&&AC.setAttribute("dy",AG*k);AA&&AC.setAttribute("x",AE.x);AC.appendChild(F.createTextNode(y[AA]));e.appendChild(AC);}}else{var y=e.getElementsByTagName("tspan");for(var AA=0,AF=y.length;AA<AF;AA++){AA&&y[AA].setAttribute("dy",AG*k);AA&&y[AA].setAttribute("x",AE.x);}}e.setAttribute("y",AE.y);var AB=R.getBBox(),AD=AE.y-(AB.y+AB.height/2);AD&&e.setAttribute("y",AE.y+AD);};var K=function(e,R){var y=0,i=0;this[0]=e;this.node=e;this.paper=R;this.attrs=this.attrs||{};this.transformations=[];this._={tx:0,ty:0,rt:{deg:0,cx:0,cy:0},sx:1,sy:1};};K.prototype.rotate=function(e,R,y){if(e==null){if(this._.rt.cx){return[this._.rt.deg,this._.rt.cx,this._.rt.cy].join(" ");}return this._.rt.deg;}var i=this.getBBox();e=(e+"").split(x);if(e.length-1){R=parseFloat(e[1]);y=parseFloat(e[2]);}e=parseFloat(e[0]);if(R!=null){this._.rt.deg=e;}else{this._.rt.deg+=e;}(y==null)&&(R=null);this._.rt.cx=R;this._.rt.cy=y;R=R==null?i.x+i.width/2:R;y=y==null?i.y+i.height/2:y;if(this._.rt.deg){this.transformations[0]="rotate(".concat(this._.rt.deg," ",R," ",y,")");}else{this.transformations[0]="";}this.node.setAttribute("transform",this.transformations.join(" "));return this;};K.prototype.hide=function(){this.node.style.display="none";return this;};K.prototype.show=function(){this.node.style.display="block";return this;};K.prototype.remove=function(){this.node.parentNode.removeChild(this.node);};K.prototype.getBBox=function(){if(this.type=="path"){return a(this.attrs.path);}if(this.node.style.display=="none"){this.show();var y=true;}var AC={};try{AC=this.node.getBBox();}catch(AA){}finally{AC=AC||{};}if(this.type=="text"){AC={x:AC.x,y:Infinity,width:AC.width,height:0};for(var R=0,z=this.node.getNumberOfChars();R<z;R++){var AB=this.node.getExtentOfChar(R);(AB.y<AC.y)&&(AC.y=AB.y);(AB.y+AB.height-AC.y>AC.height)&&(AC.height=AB.y+AB.height-AC.y);}}y&&this.hide();return AC;};K.prototype.attr=function(){if(arguments.length==1&&typeof arguments[0]=="string"){if(arguments[0]=="translation"){return this.translate();}if(arguments[0]=="rotation"){return this.rotate();}if(arguments[0]=="scale"){return this.scale();}return this.attrs[arguments[0]];}if(arguments.length==1&&E.isArray(arguments[0])){var R={};for(var e in arguments[0]){R[arguments[0][e]]=this.attrs[arguments[0][e]];}return R;}if(arguments.length==2){var i={};i[arguments[0]]=arguments[1];d(this,i);}else{if(arguments.length==1&&typeof arguments[0]=="object"){d(this,arguments[0]);}}return this;};K.prototype.toFront=function(){this.node.parentNode.appendChild(this.node);return this;};K.prototype.toBack=function(){if(this.node.parentNode.firstChild!=this.node){this.node.parentNode.insertBefore(this.node,this.node.parentNode.firstChild);}return this;};K.prototype.insertAfter=function(R){if(R.node.nextSibling){R.node.parentNode.insertBefore(this.node,R.node.nextSibling);}else{R.node.parentNode.appendChild(this.node);}return this;};K.prototype.insertBefore=function(R){var e=R.node;e.parentNode.insertBefore(this.node,e);return this;};var b=function(e,R,AB,AA){R=n(R);AB=n(AB);var z=F.createElementNS(e.svgns,"circle");z.setAttribute("cx",R);z.setAttribute("cy",AB);z.setAttribute("r",AA);z.setAttribute("fill","none");z.setAttribute("stroke","#000");if(e.canvas){e.canvas.appendChild(z);}var i=new K(z,e);i.attrs=i.attrs||{};i.attrs.cx=R;i.attrs.cy=AB;i.attrs.r=AA;i.attrs.stroke="#000";i.type="circle";return i;};var h=function(i,R,AD,e,AB,AC){R=n(R);AD=n(AD);var AA=F.createElementNS(i.svgns,"rect");AA.setAttribute("x",R);AA.setAttribute("y",AD);AA.setAttribute("width",e);AA.setAttribute("height",AB);if(AC){AA.setAttribute("rx",AC);AA.setAttribute("ry",AC);}AA.setAttribute("fill","none");AA.setAttribute("stroke","#000");if(i.canvas){i.canvas.appendChild(AA);}var z=new K(AA,i);z.attrs=z.attrs||{};z.attrs.x=R;z.attrs.y=AD;z.attrs.width=e;z.attrs.height=AB;z.attrs.stroke="#000";if(AC){z.attrs.rx=z.attrs.ry=AC;}z.type="rect";return z;};var G=function(e,R,AC,AB,AA){R=n(R);AC=n(AC);var z=F.createElementNS(e.svgns,"ellipse");z.setAttribute("cx",R);z.setAttribute("cy",AC);z.setAttribute("rx",AB);z.setAttribute("ry",AA);z.setAttribute("fill","none");z.setAttribute("stroke","#000");if(e.canvas){e.canvas.appendChild(z);}var i=new K(z,e);i.attrs=i.attrs||{};i.attrs.cx=R;i.attrs.cy=AC;i.attrs.rx=AB;i.attrs.ry=AA;i.attrs.stroke="#000";i.type="ellipse";return i;};var N=function(i,AC,R,AD,e,AB){var AA=F.createElementNS(i.svgns,"image");AA.setAttribute("x",R);AA.setAttribute("y",AD);AA.setAttribute("width",e);AA.setAttribute("height",AB);AA.setAttribute("preserveAspectRatio","none");AA.setAttributeNS(i.xlink,"href",AC);if(i.canvas){i.canvas.appendChild(AA);}var z=new K(AA,i);z.attrs=z.attrs||{};z.attrs.src=AC;z.attrs.x=R;z.attrs.y=AD;z.attrs.width=e;z.attrs.height=AB;z.type="image";return z;};var g=function(e,R,AB,AA){var z=F.createElementNS(e.svgns,"text");z.setAttribute("x",R);z.setAttribute("y",AB);z.setAttribute("text-anchor","middle");if(e.canvas){e.canvas.appendChild(z);}var i=new K(z,e);i.attrs=i.attrs||{};i.attrs.text=AA;i.attrs.x=R;i.attrs.y=AB;i.type="text";d(i,{font:O.font,stroke:"none",fill:"#000",text:AA});return i;};var c=function(e,R){this.width=e||this.width;this.height=R||this.height;this.canvas.setAttribute("width",this.width);this.canvas.setAttribute("height",this.height);return this;};var J=function(){var z=f.apply(null,arguments),i=z.container,e=z.x,AC=z.y,AA=z.width,R=z.height;if(!i){throw new Error("SVG container not found.");}B.canvas=F.createElementNS(B.svgns,"svg");B.canvas.setAttribute("width",AA||512);B.width=AA||512;B.canvas.setAttribute("height",R||342);B.height=R||342;if(i==1){F.body.appendChild(B.canvas);B.canvas.style.position="absolute";B.canvas.style.left=e+"px";B.canvas.style.top=AC+"px";}else{if(i.firstChild){i.insertBefore(B.canvas,i.firstChild);}else{i.appendChild(B.canvas);}}i={canvas:B.canvas,clear:function(){while(this.canvas.firstChild){this.canvas.removeChild(this.canvas.firstChild);}this.defs=F.createElementNS(B.svgns,"defs");this.canvas.appendChild(this.defs);}};for(var AB in B){if(AB!="create"){i[AB]=B[AB];}}A.call(i,i,E.fn);i.clear();i.raphael=E;return i;};B.remove=function(){this.canvas.parentNode&&this.canvas.parentNode.removeChild(this.canvas);};B.svgns="http://www.w3.org/2000/svg";B.xlink="http://www.w3.org/1999/xlink";B.safari=function(){if({"Apple Computer, Inc.":1,"Google Inc.":1}[navigator.vendor]){var R=this.rect(-this.width,-this.height,this.width*3,this.height*3).attr({stroke:"none"});setTimeout(function(){R.remove();});}};}if(E.vml){var X=function(AB){var z=o(AB);for(var e=0,y=z.length;e<y;e++){z[e][0]=(z[e][0]+"").toLowerCase();z[e][0]=="z"&&(z[e][0]="x");for(var R=1,AA=z[e].length;R<AA;R++){z[e][R]=Math.round(z[e][R]);}}return(z+"");};E.toString=function(){return"Your browser doesn\u2019t support SVG. Assuming it is Internet Explorer and falling down to VML.\nYou are running Rapha\u00ebl "+this.version;};var v=function(R,AA){var y=u("group"),AB=y.style;AB.position="absolute";AB.left=0;AB.top=0;AB.width=AA.width+"px";AB.height=AA.height+"px";y.coordsize=AA.coordsize;y.coordorigin=AA.coordorigin;var i=u("shape"),e=i.style;e.width=AA.width+"px";e.height=AA.height+"px";i.path="";i.coordsize=this.coordsize;i.coordorigin=this.coordorigin;y.appendChild(i);var z=new K(i,y,AA);z.isAbsolute=true;z.type="path";z.path=[];z.Path="";if(R){z.attrs.path=E.parsePathString(R);z.node.path=X(z.attrs.path);}d(z,{fill:"none",stroke:"#000"});z.setBox();AA.canvas.appendChild(y);return z;};var d=function(i,z){i.attrs=i.attrs||{};var y=i.node,AF=i.attrs,AJ=y.style,AI,AD=i;for(var AC in z){AF[AC]=z[AC];}z.href&&(y.href=z.href);z.title&&(y.title=z.title);z.target&&(y.target=z.target);if(z.path&&i.type=="path"){AF.path=E.parsePathString(z.path);y.path=X(AF.path);}if(z.rotation!=null){i.rotate(z.rotation,true);}if(z.translation){AI=(z.translation+"").split(x);i.translate(AI[0],AI[1]);}if(z.scale){AI=(z.scale+"").split(x);i.scale(+AI[0]||1,+AI[1]||+AI[0]||1,+AI[2]||null,+AI[3]||null);}if(i.type=="image"&&z.src){y.src=z.src;}if(i.type=="image"&&z.opacity){y.filterOpacity=" progid:DXImageTransform.Microsoft.Alpha(opacity="+(z.opacity*100)+")";AJ.filter=(y.filterMatrix||"")+(y.filterOpacity||"");}z.font&&(AJ.font=z.font);z["font-family"]&&(AJ.fontFamily='"'+z["font-family"].split(",")[0].replace(/^['"]+|['"]+$/g,"")+'"');z["font-size"]&&(AJ.fontSize=z["font-size"]);z["font-weight"]&&(AJ.fontWeight=z["font-weight"]);z["font-style"]&&(AJ.fontStyle=z["font-style"]);if(z.opacity!=null||z["stroke-width"]!=null||z.fill!=null||z.stroke!=null||z["stroke-width"]!=null||z["stroke-opacity"]!=null||z["fill-opacity"]!=null||z["stroke-dasharray"]!=null||z["stroke-miterlimit"]!=null||z["stroke-linejoin"]!=null||z["stroke-linecap"]!=null){y=i.shape||y;var AH=(y.getElementsByTagName("fill")&&y.getElementsByTagName("fill")[0]),e=false;!AH&&(e=AH=u("fill"));if("fill-opacity" in z||"opacity" in z){var AB=((+AF["fill-opacity"]+1||2)-1)*((+AF.opacity+1||2)-1);AB<0&&(AB=0);AB>1&&(AB=1);AH.opacity=AB;}z.fill&&(AH.on=true);if(AH.on==null||z.fill=="none"){AH.on=false;}if(AH.on&&z.fill){var AA=z.fill.match(/^url\(([^\)]+)\)$/i);if(AA){AH.src=AA[1];AH.type="tile";}else{AH.color=E.getRGB(z.fill).hex;AH.src="";AH.type="solid";}}e&&y.appendChild(AH);var AG=(y.getElementsByTagName("stroke")&&y.getElementsByTagName("stroke")[0]),R=false;!AG&&(R=AG=u("stroke"));if((z.stroke&&z.stroke!="none")||z["stroke-width"]||z["stroke-opacity"]!=null||z["stroke-dasharray"]||z["stroke-miterlimit"]||z["stroke-linejoin"]||z["stroke-linecap"]){AG.on=true;}(z.stroke=="none"||AG.on==null||z.stroke==0||z["stroke-width"]==0)&&(AG.on=false);AG.on&&z.stroke&&(AG.color=E.getRGB(z.stroke).hex);var AB=((+AF["stroke-opacity"]+1||2)-1)*((+AF.opacity+1||2)-1);AB<0&&(AB=0);AB>1&&(AB=1);AG.opacity=AB;z["stroke-linejoin"]&&(AG.joinstyle=z["stroke-linejoin"]||"miter");AG.miterlimit=z["stroke-miterlimit"]||8;z["stroke-linecap"]&&(AG.endcap={butt:"flat",square:"square",round:"round"}[z["stroke-linecap"]]||"miter");z["stroke-width"]&&(AG.weight=(parseFloat(z["stroke-width"])||1)*12/16);if(z["stroke-dasharray"]){var AE={"-":"shortdash",".":"shortdot","-.":"shortdashdot","-..":"shortdashdotdot",". ":"dot","- ":"dash","--":"longdash","- .":"dashdot","--.":"longdashdot","--..":"longdashdotdot"};AG.dashstyle=AE[z["stroke-dasharray"]]||"";}R&&y.appendChild(AG);}if(AD.type=="text"){var AJ=B.span.style;AF.font&&(AJ.font=AF.font);AF["font-family"]&&(AJ.fontFamily=AF["font-family"]);AF["font-size"]&&(AJ.fontSize=AF["font-size"]);AF["font-weight"]&&(AJ.fontWeight=AF["font-weight"]);AF["font-style"]&&(AJ.fontStyle=AF["font-style"]);B.span.innerHTML=AD.node.string.replace(/</g,"&#60;").replace(/&/g,"&#38;").replace(/\n/g,"<br>");AD.W=AF.w=B.span.offsetWidth;AD.H=AF.h=B.span.offsetHeight;AD.X=AF.x;AD.Y=AF.y+Math.round(AD.H/2);switch(AF["text-anchor"]){case"start":AD.node.style["v-text-align"]="left";AD.bbx=Math.round(AD.W/2);break;case"end":AD.node.style["v-text-align"]="right";AD.bbx=-Math.round(AD.W/2);break;default:AD.node.style["v-text-align"]="center";break;}}};var M=function(e,R,z,y){var i=Math.round(Math.atan((parseFloat(z)-parseFloat(e))/(parseFloat(y)-parseFloat(R)))*57.29)||0;if(!i&&parseFloat(e)<parseFloat(R)){i=180;}i-=180;if(i<0){i+=360;}return i;};var m=function(AC,AB){AB=L(AB);AC.attrs=AC.attrs||{};var e=AC.attrs,AA=AC.node.getElementsByTagName("fill");AC.attrs.gradient=AB;AC=AC.shape||AC.node;if(AA.length){AA=AA[0];}else{AA=u("fill");}if(AB.dots.length){AA.on=true;AA.method="none";AA.type=((AB.type+"").toLowerCase()=="radial")?"gradientTitle":"gradient";if(typeof AB.dots[0].color!="undefined"){AA.color=E.getRGB(AB.dots[0].color).hex;}if(typeof AB.dots[AB.dots.length-1].color!="undefined"){AA.color2=E.getRGB(AB.dots[AB.dots.length-1].color).hex;}var AD=[];for(var y=0,z=AB.dots.length;y<z;y++){if(AB.dots[y].offset){AD.push(AB.dots[y].offset+" "+E.getRGB(AB.dots[y].color).hex);}}var R=typeof AB.dots[AB.dots.length-1].opacity=="undefined"?(typeof e.opacity=="undefined"?1:e.opacity):AB.dots[AB.dots.length-1].opacity;if(AD.length){AA.colors.value=AD.join(",");R=typeof e.opacity=="undefined"?1:e.opacity;}else{AA.colors&&(AA.colors.value="0% "+AA.color);}AA.opacity=R;if(typeof AB.angle!="undefined"){AA.angle=(-AB.angle+270)%360;}else{if(AB.vector){AA.angle=M.apply(null,AB.vector);}}if((AB.type+"").toLowerCase()=="radial"){AA.focus="100%";AA.focusposition="0.5 0.5";}}};var K=function(z,AB,R){var AA=0,i=0,e=0,y=1;this[0]=z;this.node=z;this.X=0;this.Y=0;this.attrs={};this.Group=AB;this.paper=R;this._={tx:0,ty:0,rt:{deg:0},sx:1,sy:1};};K.prototype.rotate=function(e,R,i){if(e==null){if(this._.rt.cx){return[this._.rt.deg,this._.rt.cx,this._.rt.cy].join(" ");}return this._.rt.deg;}e=(e+"").split(x);if(e.length-1){R=parseFloat(e[1]);i=parseFloat(e[2]);}e=parseFloat(e[0]);if(R!=null){this._.rt.deg=e;}else{this._.rt.deg+=e;}(i==null)&&(R=null);this._.rt.cx=R;this._.rt.cy=i;this.setBox(this.attrs,R,i);this.Group.style.rotation=this._.rt.deg;return this;};K.prototype.setBox=function(AB,AC,AA){var e=this.Group.style,AD=(this.shape&&this.shape.style)||this.node.style;AB=AB||{};for(var AE in AB){this.attrs[AE]=AB[AE];}AC=AC||this._.rt.cx;AA=AA||this._.rt.cy;var AH=this.attrs,AK,AJ,AL,AG;switch(this.type){case"circle":AK=AH.cx-AH.r;AJ=AH.cy-AH.r;AL=AG=AH.r*2;break;case"ellipse":AK=AH.cx-AH.rx;AJ=AH.cy-AH.ry;AL=AH.rx*2;AG=AH.ry*2;break;case"rect":case"image":AK=AH.x;AJ=AH.y;AL=AH.width||0;AG=AH.height||0;break;case"text":this.textpath.v=["m",Math.round(AH.x),", ",Math.round(AH.y-2),"l",Math.round(AH.x)+1,", ",Math.round(AH.y-2)].join("");AK=AH.x-Math.round(this.W/2);AJ=AH.y-this.H/2;AL=this.W;AG=this.H;break;case"path":if(!this.attrs.path){AK=0;AJ=0;AL=this.paper.width;AG=this.paper.height;}else{var AF=a(this.attrs.path);AK=AF.x;AJ=AF.y;AL=AF.width;AG=AF.height;}break;default:AK=0;AJ=0;AL=this.paper.width;AG=this.paper.height;break;}AC=(AC==null)?AK+AL/2:AC;AA=(AA==null)?AJ+AG/2:AA;var z=AC-this.paper.width/2,AI=AA-this.paper.height/2;if(this.type=="path"||this.type=="text"){(e.left!=z+"px")&&(e.left=z+"px");(e.top!=AI+"px")&&(e.top=AI+"px");this.X=this.type=="text"?AK:-z;this.Y=this.type=="text"?AJ:-AI;this.W=AL;this.H=AG;(AD.left!=-z+"px")&&(AD.left=-z+"px");(AD.top!=-AI+"px")&&(AD.top=-AI+"px");}else{(e.left!=z+"px")&&(e.left=z+"px");(e.top!=AI+"px")&&(e.top=AI+"px");this.X=AK;this.Y=AJ;this.W=AL;this.H=AG;(e.width!=this.paper.width+"px")&&(e.width=this.paper.width+"px");(e.height!=this.paper.height+"px")&&(e.height=this.paper.height+"px");(AD.left!=AK-z+"px")&&(AD.left=AK-z+"px");(AD.top!=AJ-AI+"px")&&(AD.top=AJ-AI+"px");(AD.width!=AL+"px")&&(AD.width=AL+"px");(AD.height!=AG+"px")&&(AD.height=AG+"px");var AM=(+AB.r||0)/(Math.min(AL,AG));if(this.type=="rect"&&this.arcsize!=AM&&(AM||this.arcsize)){var R=u(AM?"roundrect":"rect");R.arcsize=AM;this.Group.appendChild(R);this.node.parentNode.removeChild(this.node);this.node=R;this.arcsize=AM;d(this,this.attrs);this.setBox(this.attrs);}}};K.prototype.hide=function(){this.Group.style.display="none";return this;};K.prototype.show=function(){this.Group.style.display="block";return this;};K.prototype.getBBox=function(){if(this.type=="path"){return a(this.attrs.path);}return{x:this.X+(this.bbx||0),y:this.Y,width:this.W,height:this.H};};K.prototype.remove=function(){this[0].parentNode.removeChild(this[0]);this.Group.parentNode.removeChild(this.Group);this.shape&&this.shape.parentNode.removeChild(this.shape);};K.prototype.attr=function(){if(arguments.length==1&&typeof arguments[0]=="string"){if(arguments[0]=="translation"){return this.translate();}if(arguments[0]=="rotation"){return this.rotate();}if(arguments[0]=="scale"){return this.scale();}return this.attrs[arguments[0]];}if(this.attrs&&arguments.length==1&&E.isArray(arguments[0])){var R={};for(var e=0,y=arguments[0].length;e<y;e++){R[arguments[0][e]]=this.attrs[arguments[0][e]];}return R;}var z;if(arguments.length==2){z={};z[arguments[0]]=arguments[1];}if(arguments.length==1&&typeof arguments[0]=="object"){z=arguments[0];}if(z){if(z.gradient){m(this,z.gradient);}if(z.text&&this.type=="text"){this.node.string=z.text;}d(this,z);this.setBox(this.attrs);}return this;};K.prototype.toFront=function(){this.Group.parentNode.appendChild(this.Group);return this;};K.prototype.toBack=function(){if(this.Group.parentNode.firstChild!=this.Group){this.Group.parentNode.insertBefore(this.Group,this.Group.parentNode.firstChild);}return this;};K.prototype.insertAfter=function(R){if(R.Group.nextSibling){R.Group.parentNode.insertBefore(this.Group,R.Group.nextSibling);}else{R.Group.parentNode.appendChild(this.Group);}return this;};K.prototype.insertBefore=function(R){R.Group.parentNode.insertBefore(this.Group,R.Group);return this;};var b=function(e,AE,AD,R){var AA=u("group"),z=AA.style,i=u("oval"),AC=i.style;z.position="absolute";z.left=0;z.top=0;z.width=e.width+"px";z.height=e.height+"px";AA.coordsize=e.coordsize;AA.coordorigin=e.coordorigin;AA.appendChild(i);var AB=new K(i,AA,e);AB.type="circle";d(AB,{stroke:"#000",fill:"none"});AB.attrs.cx=AE;AB.attrs.cy=AD;AB.attrs.r=R;AB.setBox({x:AE-R,y:AD-R,width:R*2,height:R*2});e.canvas.appendChild(AA);return AB;};var h=function(e,AE,AD,AF,AA,R){var AB=u("group"),z=AB.style,i=u(R?"roundrect":"rect"),AG=(+R||0)/(Math.min(AF,AA));i.arcsize=AG;z.position="absolute";z.left=0;z.top=0;z.width=e.width+"px";z.height=e.height+"px";AB.coordsize=e.coordsize;AB.coordorigin=e.coordorigin;AB.appendChild(i);var AC=new K(i,AB,e);AC.type="rect";d(AC,{stroke:"#000"});AC.arcsize=AG;AC.setBox({x:AE,y:AD,width:AF,height:AA,r:+R});e.canvas.appendChild(AB);return AC;};var G=function(R,AF,AE,i,e){var AB=u("group"),AA=AB.style,z=u("oval"),AD=z.style;AA.position="absolute";AA.left=0;AA.top=0;AA.width=R.width+"px";AA.height=R.height+"px";AB.coordsize=R.coordsize;AB.coordorigin=R.coordorigin;AB.appendChild(z);var AC=new K(z,AB,R);AC.type="ellipse";d(AC,{stroke:"#000"});AC.attrs.cx=AF;AC.attrs.cy=AE;AC.attrs.rx=i;AC.attrs.ry=e;AC.setBox({x:AF-i,y:AE-e,width:i*2,height:e*2});R.canvas.appendChild(AB);return AC;};var N=function(e,R,AF,AE,AG,AA){var AB=u("group"),z=AB.style,i=u("image"),AD=i.style;z.position="absolute";z.left=0;z.top=0;z.width=e.width+"px";z.height=e.height+"px";AB.coordsize=e.coordsize;AB.coordorigin=e.coordorigin;i.src=R;AB.appendChild(i);var AC=new K(i,AB,e);AC.type="image";AC.attrs.src=R;AC.attrs.x=AF;AC.attrs.y=AE;AC.attrs.w=AG;AC.attrs.h=AA;AC.setBox({x:AF,y:AE,width:AG,height:AA});e.canvas.appendChild(AB);return AC;};var g=function(e,AF,AE,AG){var AB=u("group"),AA=AB.style,z=u("shape"),AD=z.style,AH=u("path"),R=AH.style,i=u("textpath");AA.position="absolute";AA.left=0;AA.top=0;AA.width=e.width+"px";AA.height=e.height+"px";AB.coordsize=e.coordsize;AB.coordorigin=e.coordorigin;AH.v=["m",Math.round(AF),", ",Math.round(AE),"l",Math.round(AF)+1,", ",Math.round(AE)].join("");AH.textpathok=true;AD.width=e.width;AD.height=e.height;AA.position="absolute";AA.left=0;AA.top=0;AA.width=e.width;AA.height=e.height;i.string=AG;i.on=true;z.appendChild(i);z.appendChild(AH);AB.appendChild(z);var AC=new K(i,AB,e);AC.shape=z;AC.textpath=AH;AC.type="text";AC.attrs.text=AG;AC.attrs.x=AF;AC.attrs.y=AE;AC.attrs.w=1;AC.attrs.h=1;d(AC,{font:O.font,stroke:"none",fill:"#000"});AC.setBox();e.canvas.appendChild(AB);return AC;};var c=function(i,R){var e=this.canvas.style;this.width=i||this.width;this.height=R||this.height;e.width=this.width+"px";e.height=this.height+"px";e.clip="rect(0 "+this.width+"px "+this.height+"px 0)";this.canvas.coordsize=this.width+" "+this.height;return this;};F.createStyleSheet().addRule(".rvml","behavior:url(#default#VML)");try{!F.namespaces.rvml&&F.namespaces.add("rvml","urn:schemas-microsoft-com:vml");var u=function(R){return F.createElement("<rvml:"+R+' class="rvml">');};}catch(t){var u=function(R){return F.createElement("<"+R+' xmlns="urn:schemas-microsoft.com:vml" class="rvml">');};}var J=function(){var z=f.apply(null,arguments),e=z.container,AE=z.height,AF,i=z.width,AD=z.x,AC=z.y;if(!e){throw new Error("VML container not found.");}var AB=B.canvas=F.createElement("div"),AA=AB.style;i=parseFloat(i)||"512px";AE=parseFloat(AE)||"342px";B.width=i;B.height=AE;B.coordsize=i+" "+AE;B.coordorigin="0 0";B.span=F.createElement("span");AF=B.span.style;AB.appendChild(B.span);AF.position="absolute";AF.left="-99999px";AF.top="-99999px";AF.padding=0;AF.margin=0;AF.lineHeight=1;AF.display="inline";AA.width=i+"px";AA.height=AE+"px";AA.position="absolute";AA.clip="rect(0 "+i+"px "+AE+"px 0)";if(e==1){F.body.appendChild(AB);AA.left=AD+"px";AA.top=AC+"px";e={style:{width:i,height:AE}};}else{e.style.width=i;e.style.height=AE;if(e.firstChild){e.insertBefore(AB,e.firstChild);}else{e.appendChild(AB);}}for(var R in B){e[R]=B[R];}A.call(e,e,E.fn);e.clear=function(){while(AB.firstChild){AB.removeChild(AB.firstChild);}};e.raphael=E;return e;};B.remove=function(){this.canvas.parentNode.removeChild(this.canvas);};B.safari=function(){};}var H=(function(){if(F.addEventListener){return function(z,i,e,R){var y=function(AA){return e.call(R,AA);};z.addEventListener(i,y,false);return function(){z.removeEventListener(i,y,false);return true;};};}else{if(F.attachEvent){return function(AA,y,i,e){var z=function(AB){return i.call(e,AB||l.event);};AA.attachEvent("on"+y,z);var R=function(){AA.detachEvent("on"+y,z);return true;};if(y=="mouseover"){AA.attachEvent("onmouseenter",z);return function(){AA.detachEvent("onmouseenter",z);return R();};}else{if(y=="mouseout"){AA.attachEvent("onmouseleave",z);return function(){AA.detachEvent("onmouseleave",z);return R();};}}return R;};}}})();for(var q=U.length;q--;){(function(R){K.prototype[R]=function(e){if(typeof e=="function"){this.events=this.events||{};this.events[R]=this.events[R]||{};this.events[R][e]=this.events[R][e]||[];this.events[R][e].push(H(this.shape||this.node,R,e,this));}return this;};K.prototype["un"+R]=function(e){this.events&&this.events[R]&&this.events[R][e]&&this.events[R][e].length&&this.events[R][e].shift()()&&!this.events[R][e].length&&delete this.events[R][e];};})(U[q]);}B.circle=function(R,i,e){return b(this,R,i,e);};B.rect=function(R,AA,e,i,z){return h(this,R,AA,e,i,z);};B.ellipse=function(R,z,i,e){return G(this,R,z,i,e);};B.path=function(R){var e=E.isArray(arguments[1])?[0].concat(arguments[1]):arguments;R&&typeof R=="string"&&e.length-1&&(R=R.replace(/\{(\d+)\}/g,function(z,y){return e[++y]||0;}));return v(R,this);};B.image=function(z,R,AA,e,i){return N(this,z,R,AA,e,i);};B.text=function(R,i,e){return g(this,R,i,e);};B.set=function(R){arguments.length>1&&(R=Array.prototype.splice.call(arguments,0,arguments.length));return new I(R);};B.setSize=c;K.prototype.stop=function(){clearTimeout(this.animation_in_progress);return this;};K.prototype.scale=function(AJ,AI,z,e){if(AJ==null&&AI==null){return{x:this._.sx,y:this._.sy,toString:function(){return +this.x.toFixed(3)+" "+(+this.y.toFixed(3));}};}AI=AI||AJ;!+AI&&(AI=AJ);var AN,AL,AM,AK,AZ=this.attrs;if(AJ!=0){var AH=this.type=="path"?a(AZ.path):this.getBBox(),AE=AH.x+AH.width/2,AB=AH.y+AH.height/2,AY=AJ/this._.sx,AX=AI/this._.sy;z=(+z||z==0)?z:AE;e=(+e||e==0)?e:AB;var AG=Math.round(AJ/Math.abs(AJ)),AD=Math.round(AI/Math.abs(AI)),AQ=this.node.style,Ab=z+(AE-z)*AG*AY,Aa=e+(AB-e)*AD*AX;switch(this.type){case"rect":case"image":var AF=AZ.width*AG*AY,AP=AZ.height*AD*AX,AC=Ab-AF/2,AA=Aa-AP/2;this.attr({width:AF,height:AP,x:AC,y:AA});break;case"circle":case"ellipse":this.attr({rx:AZ.rx*AY,ry:AZ.ry*AX,r:AZ.r*AY,cx:Ab,cy:Aa});break;case"path":var AS=C(AZ.path),AT=true;for(var AV=0,AO=AS.length;AV<AO;AV++){var AR=AS[AV];if(AR[0].toUpperCase()=="M"&&AT){continue;}else{AT=false;}if(E.svg&&AR[0].toUpperCase()=="A"){AR[AS[AV].length-2]*=AY;AR[AS[AV].length-1]*=AX;AR[1]*=AY;AR[2]*=AX;AR[5]=+(AG+AD?!!+AR[5]:!+AR[5]);}else{for(var AU=1,AW=AR.length;AU<AW;AU++){AR[AU]*=(AU%2)?AY:AX;}}}var R=a(AS),AN=Ab-R.x-R.width/2,AL=Aa-R.y-R.height/2;AS=C(AS);AS[0][1]+=AN;AS[0][2]+=AL;this.attr({path:AS.join(" ")});break;}if(this.type in {text:1,image:1}&&(AG!=1||AD!=1)){if(this.transformations){this.transformations[2]="scale(".concat(AG,",",AD,")");this.node.setAttribute("transform",this.transformations.join(" "));AN=(AG==-1)?-AZ.x-(AF||0):AZ.x;AL=(AD==-1)?-AZ.y-(AP||0):AZ.y;this.attr({x:AN,y:AL});AZ.fx=AG-1;AZ.fy=AD-1;}else{this.node.filterMatrix=" progid:DXImageTransform.Microsoft.Matrix(M11=".concat(AG,", M12=0, M21=0, M22=",AD,", Dx=0, Dy=0, sizingmethod='auto expand', filtertype='bilinear')");AQ.filter=(this.node.filterMatrix||"")+(this.node.filterOpacity||"");}}else{if(this.transformations){this.transformations[2]="";this.node.setAttribute("transform",this.transformations.join(" "));AZ.fx=0;AZ.fy=0;}else{this.node.filterMatrix="";AQ.filter=(this.node.filterMatrix||"")+(this.node.filterOpacity||"");}}AZ.scale=[AJ,AI,z,e].join(" ");this._.sx=AJ;this._.sy=AI;}return this;};E.easing_formulas={linear:function(R){return R;},"<":function(R){return Math.pow(R,3);},">":function(R){return Math.pow(R-1,3)+1;},"<>":function(R){R=R*2;if(R<1){return Math.pow(R,3)/2;}R-=2;return(Math.pow(R,3)+2)/2;},backIn:function(e){var R=1.70158;return e*e*((R+1)*e-R);},backOut:function(e){e=e-1;var R=1.70158;return e*e*((R+1)*e+R)+1;},elastic:function(i){if(i==0||i==1){return i;}var e=0.3,R=e/4;return Math.pow(2,-10*i)*Math.sin((i-R)*(2*Math.PI)/e)+1;},bounce:function(y){var e=7.5625,i=2.75,R;if(y<(1/i)){R=e*y*y;}else{if(y<(2/i)){y-=(1.5/i);R=e*y*y+0.75;}else{if(y<(2.5/i)){y-=(2.25/i);R=e*y*y+0.9375;}else{y-=(2.625/i);R=e*y*y+0.984375;}}}return R;}};K.prototype.animate=function(AR,AI,AH,z){clearTimeout(this.animation_in_progress);if(typeof AH=="function"||!AH){z=AH||null;}var AL={},e={},AF={},AE={x:0,y:0};for(var AJ in AR){if(AJ in T){AL[AJ]=this.attr(AJ);(typeof AL[AJ]=="undefined")&&(AL[AJ]=O[AJ]);e[AJ]=AR[AJ];switch(T[AJ]){case"number":AF[AJ]=(e[AJ]-AL[AJ])/AI;break;case"colour":AL[AJ]=E.getRGB(AL[AJ]);var AK=E.getRGB(e[AJ]);AF[AJ]={r:(AK.r-AL[AJ].r)/AI,g:(AK.g-AL[AJ].g)/AI,b:(AK.b-AL[AJ].b)/AI};break;case"path":var AA=o(AL[AJ],e[AJ]);AL[AJ]=AA[0];e[AJ]=AA[1];AF[AJ]=[];for(var AN=0,AD=AL[AJ].length;AN<AD;AN++){AF[AJ][AN]=[0];for(var AM=1,AP=AL[AJ][AN].length;AM<AP;AM++){AF[AJ][AN][AM]=(e[AJ][AN][AM]-AL[AJ][AN][AM])/AI;}}break;case"csv":var R=(AR[AJ]+"").split(x),AC=(AL[AJ]+"").split(x);switch(AJ){case"translation":AL[AJ]=[0,0];AF[AJ]=[R[0]/AI,R[1]/AI];break;case"rotation":AL[AJ]=(AC[1]==R[1]&&AC[2]==R[2])?AC:[0,R[1],R[2]];AF[AJ]=[(R[0]-AL[AJ][0])/AI,0,0];break;case"scale":AR[AJ]=R;AL[AJ]=(AL[AJ]+"").split(x);AF[AJ]=[(R[0]-AL[AJ][0])/AI,(R[1]-AL[AJ][1])/AI,0,0];}e[AJ]=R;}}}var y=+new Date,AG=0,AQ=function(i){return +i>255?255:+i;},AB=this;(function AO(){var AT=new Date-y,Ab={},AS;if(AT<AI){var AZ=E.easing_formulas[AH]?E.easing_formulas[AH](AT/AI):AT/AI;for(var AX in AL){switch(T[AX]){case"number":AS=+AL[AX]+AZ*AI*AF[AX];break;case"colour":AS="rgb("+[AQ(Math.round(AL[AX].r+AZ*AI*AF[AX].r)),AQ(Math.round(AL[AX].g+AZ*AI*AF[AX].g)),AQ(Math.round(AL[AX].b+AZ*AI*AF[AX].b))].join(",")+")";break;case"path":AS=[];for(var AV=0,Ac=AL[AX].length;AV<Ac;AV++){AS[AV]=[AL[AX][AV][0]];for(var AU=1,AW=AL[AX][AV].length;AU<AW;AU++){AS[AV][AU]=+AL[AX][AV][AU]+AZ*AI*AF[AX][AV][AU];}AS[AV]=AS[AV].join(" ");}AS=AS.join(" ");break;case"csv":switch(AX){case"translation":var Aa=AF[AX][0]*(AT-AG),AY=AF[AX][1]*(AT-AG);AE.x+=Aa;AE.y+=AY;AS=[Aa,AY].join(" ");break;case"rotation":AS=+AL[AX][0]+AZ*AI*AF[AX][0];AL[AX][1]&&(AS+=","+AL[AX][1]+","+AL[AX][2]);break;case"scale":AS=[+AL[AX][0]+AZ*AI*AF[AX][0],+AL[AX][1]+AZ*AI*AF[AX][1],(2 in AR[AX]?AR[AX][2]:""),(3 in AR[AX]?AR[AX][3]:"")].join(" ");}break;}Ab[AX]=AS;}AB.attr(Ab);AB.animation_in_progress=setTimeout(AO);E.svg&&B.safari();}else{(AE.x||AE.y)&&AB.translate(-AE.x,-AE.y);AB.attr(AR);clearTimeout(AB.animation_in_progress);E.svg&&B.safari();(typeof z=="function")&&z.call(AB);}AG=AT;})();return this;};K.prototype.translate=function(R,i){if(R==null){return{x:this._.tx,y:this._.ty};}this._.tx+=+R;this._.ty+=+i;switch(this.type){case"circle":case"ellipse":this.attr({cx:+R+this.attrs.cx,cy:+i+this.attrs.cy});break;case"rect":case"image":case"text":this.attr({x:+R+this.attrs.x,y:+i+this.attrs.y});break;case"path":var e=C(this.attrs.path);e[0][1]+=+R;e[0][2]+=+i;this.attr({path:e});break;}return this;};var I=function(R){this.items=[];this.length=0;if(R){for(var e=0,y=R.length;e<y;e++){if(R[e]&&(R[e].constructor==K||R[e].constructor==I)){this[this.items.length]=this.items[this.items.length]=R[e];this.length++;}}}};I.prototype.push=function(){var z,R;for(var e=0,y=arguments.length;e<y;e++){z=arguments[e];if(z&&(z.constructor==K||z.constructor==I)){R=this.items.length;this[R]=this.items[R]=z;this.length++;}}return this;};for(var r in K.prototype){I.prototype[r]=(function(R){return function(){for(var e=0,y=this.items.length;e<y;e++){this.items[e][R].apply(this.items[e],arguments);}return this;};})(r);}I.prototype.attr=function(e,AB){if(e&&E.isArray(e)&&typeof e[0]=="object"){for(var R=0,AA=e.length;R<AA;R++){this.items[R].attr(e[R]);}}else{for(var y=0,z=this.items.length;y<z;y++){this.items[y].attr.apply(this.items[y],arguments);}}return this;};I.prototype.getBBox=function(){var R=[],AC=[],e=[],AA=[];for(var z=this.items.length;z--;){var AB=this.items[z].getBBox();R.push(AB.x);AC.push(AB.y);e.push(AB.x+AB.width);AA.push(AB.y+AB.height);}R=Math.min.apply(Math,R);AC=Math.min.apply(Math,AC);return{x:R,y:AC,width:Math.max.apply(Math,e)-R,height:Math.max.apply(Math,AA)-AC};};E.registerFont=function(e){if(!e.face){return e;}this.fonts=this.fonts||{};var y={w:e.w,face:{},glyphs:{}},i=e.face["font-family"];for(var AB in e.face){y.face[AB]=e.face[AB];}if(this.fonts[i]){this.fonts[i].push(y);}else{this.fonts[i]=[y];}if(!e.svg){y.face["units-per-em"]=parseInt(e.face["units-per-em"],10);for(var z in e.glyphs){var AA=e.glyphs[z];y.glyphs[z]={w:AA.w,k:{},d:AA.d&&"M"+AA.d.replace(/[mlcxtrv]/g,function(AC){return{l:"L",c:"C",x:"z",t:"m",r:"l",v:"c"}[AC]||"M";})+"z"};if(AA.k){for(var R in AA.k){y.glyphs[z].k[R]=AA.k[R];}}}}return e;};B.getFont=function(AD,AE,e,z){z=z||"normal";e=e||"normal";AE=+AE||{normal:400,bold:700,lighter:300,bolder:800}[AE]||400;var AA=E.fonts[AD];if(!AA){var y=new RegExp("(^|\\s)"+AD.replace(/[^\w\d\s+!~.:_-]/g,"")+"(\\s|$)","i");for(var R in E.fonts){if(y.test(R)){AA=E.fonts[R];break;}}}var AB;if(AA){for(var AC=0,AF=AA.length;AC<AF;AC++){AB=AA[AC];if(AB.face["font-weight"]==AE&&(AB.face["font-style"]==e||!AB.face["font-style"])&&AB.face["font-stretch"]==z){break;}}}return AB;};B.print=function(AG,AF,AD,e,AK){var AB=this.set(),AE=(AD+"").split(""),R=0,AJ="",AA;typeof e=="string"&&(e=this.getFont(e));if(e){AA=(AK||16)/e.face["units-per-em"];for(var AC=0,AH=AE.length;AC<AH;AC++){var z=AC&&e.glyphs[AE[AC-1]]||{},AI=e.glyphs[AE[AC]];R+=AC?(z.w||e.w)+(z.k&&z.k[AE[AC]]||0):0;AI&&AI.d&&AB.push(this.path(AI.d).attr({fill:"#000",stroke:"none",translation:[R,0]}));}AB.scale(AA,AA,0,AF).translate(AG,(AK||16)/2);}return AB;};E.ninja=function(){var R=window.Raphael;if(p.was){window.Raphael=p.is;}else{try{delete window.Raphael;}catch(i){window.Raphael=void (0);}}return R;};E.el=K.prototype;return E;})();